/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.menu;

import com.sas.solstice.platform.application.common.api.IAvailabilityPolicy;
import com.sas.solstice.platform.application.common.api.command.ICommand;
import com.sas.solstice.platform.application.common.api.command.ICommandProvider;
import com.sas.solstice.platform.application.common.api.menu.IMenu;
import com.sas.solstice.platform.application.common.api.menu.IMenuProvider;
import java.util.Iterator;
import java.util.List;

public class ConsoleMenuVisibilityPolicy
implements IAvailabilityPolicy<IMenu> {
    private ICommandProvider commandProvider;
    private IMenuProvider menuProvider;

    public ConsoleMenuVisibilityPolicy(IMenuProvider menuProvider, ICommandProvider commandProvider) {
        if (menuProvider == null) {
            throw new IllegalArgumentException("menuProvider must not be null");
        }
        if (commandProvider == null) {
            throw new IllegalArgumentException("commandProvider must not be null");
        }
        this.setMenuProvider(menuProvider);
        this.setCommandProvider(commandProvider);
    }

    private List<IMenu> getChildrenOf(IMenu menu) {
        IMenuProvider provider = this.getMenuProvider();
        return provider.getChildrenOf(menu);
    }

    private ICommand<?> getCommand(IMenu menu) {
        String id = menu.getCommandId();
        return this.getCommand(id);
    }

    private ICommand<?> getCommand(String id) {
        if (id == null) {
            return null;
        }
        ICommandProvider commandProvider = this.getCommandProvider();
        return commandProvider.get(id);
    }

    private ICommandProvider getCommandProvider() {
        return this.commandProvider;
    }

    private IMenuProvider getMenuProvider() {
        return this.menuProvider;
    }

    private boolean hasAvailableChildren(IMenu menu) {
        List<IMenu> children = this.getChildrenOf(menu);
        Iterator<IMenu> iterator = children.iterator();
        boolean available = false;
        while (!available && iterator.hasNext()) {
            IMenu child = iterator.next();
            available = this.isAvailable(child);
        }
        return available;
    }

    private boolean hasAvailableCommand(IMenu menu) {
        ICommand<?> command = this.getCommand(menu);
        if (command == null) {
            return false;
        }
        return command.isAvailable();
    }

    @Override
    public boolean isAvailable(IMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("menu must not be null");
        }
        boolean available = menu.isAvailable();
        if (!available) {
            return false;
        }
        available = this.hasAvailableCommand(menu);
        if (available) {
            return true;
        }
        return this.hasAvailableChildren(menu);
    }

    private void setCommandProvider(ICommandProvider commandProvider) {
        this.commandProvider = commandProvider;
    }

    private void setMenuProvider(IMenuProvider menuProvider) {
        this.menuProvider = menuProvider;
    }
}

