/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.internal.util;

import com.sas.solstice.platform.application.common.api.IHierarchicalNode;
import com.sas.solstice.platform.application.common.api.IIdentifiable;
import com.sas.solstice.platform.application.common.internal.util.HierarchicalNode;
import com.sas.solstice.platform.application.common.internal.util.api.IGenericRegistry;
import java.util.ArrayList;
import java.util.List;

class HierarchyBuilder<T extends IIdentifiable> {
    HierarchyBuilder() {
    }

    List<IHierarchicalNode<T>> build(IGenericRegistry<T> registry) {
        if (registry == null) {
            throw new IllegalArgumentException("registry must not be null");
        }
        List<T> subjects = registry.getRoots();
        int size = subjects.size();
        ArrayList<IHierarchicalNode<T>> nodes = new ArrayList<IHierarchicalNode<T>>(size);
        this.buildNodes(registry, subjects, nodes);
        return nodes;
    }

    private void buildChildNodes(IGenericRegistry<T> registry, IHierarchicalNode<T> parentNode, List<T> children) {
        for (IIdentifiable child : children) {
            IHierarchicalNode<IIdentifiable> childNode = this.buildNode(registry, child);
            parentNode.addChild(childNode);
        }
    }

    private IHierarchicalNode<T> buildNode(IGenericRegistry<T> registry, T subject) {
        List<T> children = registry.getChildrenOf(subject);
        int size = children.size();
        HierarchicalNode<T> node = new HierarchicalNode<T>(subject, size);
        this.buildChildNodes(registry, node, children);
        return node;
    }

    private void buildNodes(IGenericRegistry<T> registry, List<T> subjects, List<IHierarchicalNode<T>> nodes) {
        for (IIdentifiable subject : subjects) {
            IHierarchicalNode<IIdentifiable> node = this.buildNode(registry, subject);
            nodes.add(node);
        }
    }
}

