/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.internal.util;

import com.sas.solstice.platform.application.common.api.IHierarchicalNode;
import com.sas.solstice.platform.application.common.api.IIdentifiable;
import com.sas.solstice.platform.application.common.internal.util.HierarchyBuilder;
import com.sas.solstice.platform.application.common.internal.util.api.IGenericRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GenericRegistry<T extends IIdentifiable>
implements IGenericRegistry<T> {
    private static final char NEWLINE = '\n';
    private static final char TAB = '\t';
    private Map<String, T> map;

    private static int calcuateHashedCollectionSizeEstimate(int capacity) {
        if (capacity <= 0) {
            return 0;
        }
        int size = capacity * 4 / 3 + 1;
        return size;
    }

    public GenericRegistry(int capacity) {
        this.setMap(this.createMap(capacity));
    }

    private void checkId(String id) {
        if (id != null) {
            return;
        }
        throw new IllegalArgumentException("id must not be null");
    }

    private void checkSubject(T subject) {
        if (subject != null) {
            return;
        }
        throw new IllegalArgumentException("subject must not be null");
    }

    private void collectChildOf(T parent, T subject, List<T> children) {
        String parentId;
        boolean self = parent.equals(subject);
        if (self) {
            return;
        }
        String id = parent.getId();
        boolean match = id.equals(parentId = subject.getParentId());
        if (!match) {
            return;
        }
        children.add(subject);
    }

    private void collectRoot(T subject, List<T> roots) {
        String parentId = subject.getParentId();
        if (parentId != null) {
            return;
        }
        roots.add(subject);
    }

    private Map<String, T> createMap(int capacity) {
        int size = GenericRegistry.calcuateHashedCollectionSizeEstimate(capacity);
        return new HashMap(size);
    }

    private void displayIndentOn(StringBuffer buffer, int level) {
        for (int i = 0; i < level; ++i) {
            buffer.append('\t');
        }
    }

    private void displayOn(List<T> subjects, StringBuffer buffer, int level) {
        for (IIdentifiable subject : subjects) {
            this.displayOn(subject, buffer, level);
        }
    }

    private void displayOn(T subject, StringBuffer buffer, int level) {
        this.displayIndentOn(buffer, level);
        buffer.append(subject);
        buffer.append('\n');
        List<T> children = this.getChildrenOf(subject);
        this.displayOn((T)children, buffer, level + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(String id) {
        Map<String, T> map;
        this.checkId(id);
        String validId = this.toFormattedId(id);
        Map<String, T> map2 = map = this.getMap();
        synchronized (map2) {
            return (T)((IIdentifiable)map.get(validId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> getAll() {
        Map<String, T> map;
        Map<String, T> map2 = map = this.getMap();
        synchronized (map2) {
            Collection<T> values = map.values();
            return new ArrayList<T>(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> getChildrenOf(T subject) {
        Map<String, T> map;
        if (subject == null) {
            return Collections.emptyList();
        }
        Map<String, T> map2 = map = this.getMap();
        synchronized (map2) {
            Collection<T> subjects = map.values();
            return this.getChildrenOf(subject, subjects);
        }
    }

    private List<T> getChildrenOf(T parent, Collection<T> subjects) {
        int size = subjects.size();
        ArrayList children = new ArrayList(size);
        for (IIdentifiable subject : subjects) {
            this.collectChildOf(parent, subject, children);
        }
        return children;
    }

    private Map<String, T> getMap() {
        return this.map;
    }

    @Override
    public T getParentOf(T subject) {
        if (subject == null) {
            return null;
        }
        String id = subject.getParentId();
        if (id == null) {
            return null;
        }
        return this.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> getRoots() {
        Map<String, T> map;
        Map<String, T> map2 = map = this.getMap();
        synchronized (map2) {
            Collection<T> subjects = map.values();
            return this.getRoots(subjects);
        }
    }

    private List<T> getRoots(Collection<T> subjects) {
        int size = subjects.size();
        ArrayList roots = new ArrayList(size);
        for (IIdentifiable subject : subjects) {
            this.collectRoot(subject, roots);
        }
        return roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean register(String id, T subject) {
        Map<String, T> map = this.getMap();
        String formattedId = this.toFormattedId(id);
        Map<String, T> map2 = map;
        synchronized (map2) {
            boolean exists = map.containsKey(formattedId);
            if (exists) {
                return false;
            }
            map.put(formattedId, subject);
        }
        return true;
    }

    @Override
    public boolean register(T subject) {
        this.checkSubject(subject);
        String id = subject.getId();
        return this.register(id, subject);
    }

    private void setMap(Map<String, T> map) {
        this.map = map;
    }

    @Override
    public int size() {
        Map<String, T> map = this.getMap();
        return map.size();
    }

    @Override
    public String toDisplayString() {
        List<T> roots = this.getRoots();
        int estimate = roots.size() * 15;
        StringBuffer buffer = new StringBuffer(estimate);
        this.displayOn((T)roots, buffer, 0);
        return buffer.toString();
    }

    private String toFormattedId(String id) {
        if (id == null) {
            return null;
        }
        String value = id.trim();
        return value.toLowerCase(Locale.US);
    }

    @Override
    public List<IHierarchicalNode<T>> toHierarchy() {
        HierarchyBuilder builder = new HierarchyBuilder();
        return builder.build(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    private boolean unregister(String id) {
        IIdentifiable subject;
        Map<String, T> map;
        String formattedId = this.toFormattedId(id);
        Map<String, T> map2 = map = this.getMap();
        synchronized (map2) {
            subject = (IIdentifiable)map.remove(formattedId);
        }
        return subject != null;
    }

    @Override
    public boolean unregister(T subject) {
        this.checkSubject(subject);
        String id = subject.getId();
        return this.unregister(id);
    }
}

