/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.internal.menu;

import com.sas.solstice.platform.application.common.api.IHierarchicalNode;
import com.sas.solstice.platform.application.common.api.menu.IMenu;
import com.sas.solstice.platform.application.common.api.menu.IMenuProvider;
import com.sas.solstice.platform.application.common.api.menu.IMenuRegistrar;
import com.sas.solstice.platform.application.common.internal.menu.StockMenu;
import com.sas.solstice.platform.application.common.internal.util.GenericRegistry;
import com.sas.solstice.platform.application.common.internal.util.api.IGenericRegistry;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MenuRegistry
implements IMenuRegistrar,
IMenuProvider {
    private static MenuRegistry instance;
    private static final Logger LOGGER;
    private IGenericRegistry<IMenu> registry;

    public static MenuRegistry getInstance() {
        if (instance == null) {
            throw new IllegalStateException("MenuRegistry has not been instanciated by DS");
        }
        return instance;
    }

    private static void logError(String message) {
        LOGGER.error(message);
    }

    private static void setInstance(MenuRegistry instance) {
        MenuRegistry.instance = instance;
    }

    public MenuRegistry() {
        this.setRegistry(new GenericRegistry<IMenu>(53));
        MenuRegistry.setInstance(this);
    }

    @Override
    public IMenu createBackMenu(String label) {
        return new StockMenu(Integer.MAX_VALUE, "com.sas.solstice.platform.application.common.api.menu.back", label);
    }

    @Override
    public IMenu createQuitMenu(String label) {
        return new StockMenu(0x7FFFFFFC, "com.sas.solstice.platform.application.common.api.menu.quit", label);
    }

    @Override
    public IMenu createRootMenu(String label) {
        return new StockMenu(0x7FFFFFFE, "com.sas.solstice.platform.application.common.api.menu.root", label);
    }

    @Override
    public IMenu get(String id) {
        IGenericRegistry<IMenu> registry = this.getRegistry();
        return registry.get(id);
    }

    @Override
    public List<IMenu> getAll() {
        IGenericRegistry<IMenu> registry = this.getRegistry();
        return registry.getAll();
    }

    @Override
    public IMenu getByCommandId(String commandId) {
        if (commandId == null) {
            throw new IllegalArgumentException("commandId must not be null");
        }
        List<IMenu> menus = this.getAll();
        return this.getByCommandId(commandId, menus);
    }

    private IMenu getByCommandId(String commandId, List<IMenu> menus) {
        Iterator<IMenu> iterator = menus.iterator();
        IMenu menu = null;
        boolean match = false;
        while (!match && iterator.hasNext()) {
            menu = iterator.next();
            String menuCommandId = menu.getCommandId();
            match = commandId.equalsIgnoreCase(menuCommandId);
        }
        return match ? menu : null;
    }

    @Override
    public List<IMenu> getChildrenOf(IMenu parent) {
        IGenericRegistry<IMenu> registry = this.getRegistry();
        List<IMenu> list = registry.getChildrenOf(parent);
        this.sort(list);
        return list;
    }

    @Override
    public IMenu getParentOf(IMenu menu) {
        IGenericRegistry<IMenu> registry = this.getRegistry();
        return registry.getParentOf(menu);
    }

    private IGenericRegistry<IMenu> getRegistry() {
        return this.registry;
    }

    @Override
    public List<IMenu> getRoots() {
        IGenericRegistry<IMenu> registry = this.getRegistry();
        List<IMenu> list = registry.getRoots();
        this.sort(list);
        return list;
    }

    @Override
    public void register(IMenu menu) {
        IGenericRegistry<IMenu> registry = this.getRegistry();
        boolean status = registry.register(menu);
        if (status) {
            return;
        }
        String id = menu.getId();
        String message = String.format("Failed to register the menu with the id \"%s\".", id);
        MenuRegistry.logError(message);
    }

    private void setRegistry(IGenericRegistry<IMenu> registry) {
        this.registry = registry;
    }

    private void sort(List<IMenu> list) {
        Collections.sort(list);
    }

    @Override
    public List<IHierarchicalNode<IMenu>> toHierarchy() {
        IGenericRegistry<IMenu> registry = this.getRegistry();
        return registry.toHierarchy();
    }

    @Override
    public void unregister(IMenu menu) {
        IGenericRegistry<IMenu> registry = this.getRegistry();
        boolean status = registry.unregister(menu);
        if (status) {
            return;
        }
        String id = menu.getId();
        String message = String.format("Failed to unregister the menu with the id \"%s\".", id);
        MenuRegistry.logError(message);
    }

    static {
        LOGGER = LogManager.getLogger(MenuRegistry.class);
    }
}

