/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.debug.internal.menu;

import com.sas.solstice.platform.application.common.api.IAvailabilityPolicy;
import com.sas.solstice.platform.application.common.api.IIdentifiable;
import com.sas.solstice.platform.application.common.api.menu.IMenu;
import com.sas.solstice.platform.application.common.api.menu.IMenuProvider;
import java.util.Collections;
import java.util.List;

class MenuDebugPrinter {
    MenuDebugPrinter() {
    }

    private List<IMenu> getMenus(IMenuProvider provider) {
        List<IMenu> list = provider.getAll();
        IIdentifiable.Comparator comparator = new IIdentifiable.Comparator();
        Collections.sort(list, comparator);
        return list;
    }

    String print(IMenuProvider provider, IAvailabilityPolicy<IMenu> visibilityPolicy) {
        List<IMenu> list = this.getMenus(provider);
        int count = list.size();
        StringBuffer buffer = new StringBuffer(count * 175);
        this.printOn(provider, visibilityPolicy, list, buffer);
        return buffer.toString();
    }

    private void printAvailabilityOn(IMenu menu, StringBuffer buffer) {
        boolean available = menu.isAvailable();
        String value = String.format(", available=%s", available);
        buffer.append(value);
    }

    private void printNumberOfChildrenOn(IMenuProvider provider, IMenu menu, StringBuffer buffer) {
        List<IMenu> children = provider.getChildrenOf(menu);
        int count = children.size();
        if (count == 0) {
            return;
        }
        String value = String.format(", children=%d", count);
        buffer.append(value);
    }

    private void printOn(IMenuProvider provider, IAvailabilityPolicy<IMenu> visibilityPolicy, IMenu menu, StringBuffer buffer) {
        String label = menu.getLabel();
        String debugLabel = menu.getDebugLabel();
        String value = String.format("  %s, %s", label, debugLabel);
        buffer.append(value);
        this.printParentIdOn(menu, buffer);
        this.printAvailabilityOn(menu, buffer);
        this.printVisibilityOn(visibilityPolicy, menu, buffer);
        this.printNumberOfChildrenOn(provider, menu, buffer);
        buffer.append('.');
        buffer.append('\n');
    }

    private void printOn(IMenuProvider provider, IAvailabilityPolicy<IMenu> visibilityPolicy, List<IMenu> list, StringBuffer buffer) {
        int count = list.size();
        String value = String.format("Registered Menus: %d\n", count);
        buffer.append(value);
        for (IMenu each : list) {
            this.printOn(provider, visibilityPolicy, each, buffer);
        }
    }

    private void printParentIdOn(IMenu menu, StringBuffer buffer) {
        String parentId = menu.getParentId();
        if (parentId == null) {
            return;
        }
        String value = String.format(", parentId=\"%s\"", parentId);
        buffer.append(value);
    }

    private void printVisibilityOn(IAvailabilityPolicy<IMenu> visibilityPolicy, IMenu menu, StringBuffer buffer) {
        boolean visible = visibilityPolicy.isAvailable(menu);
        String value = String.format(", visible=%s", visible);
        buffer.append(value);
    }
}

