/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.debug.internal.command;

import com.sas.solstice.platform.application.common.api.IIdentifiable;
import com.sas.solstice.platform.application.common.api.command.ICommand;
import com.sas.solstice.platform.application.common.api.command.ICommandProvider;
import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class CommandDebugPrinter {
    CommandDebugPrinter() {
    }

    private List<ICommand<?>> getCommands(ICommandProvider provider) {
        List<ICommand<?>> list = provider.getAll();
        IIdentifiable.Comparator comparator = new IIdentifiable.Comparator();
        Collections.sort(list, comparator);
        return list;
    }

    String print(ICommandProvider provider) {
        List<ICommand<?>> list = this.getCommands(provider);
        int count = list.size();
        StringBuffer buffer = new StringBuffer(count * 100);
        this.printOn(list, buffer);
        return buffer.toString();
    }

    private void printAvailabilityOn(ICommand<?> command, StringBuffer buffer) {
        boolean available = command.isAvailable();
        String value = String.format(", available=%s", available);
        buffer.append(value);
    }

    private void printOn(ICommand<?> each, StringBuffer buffer) {
        buffer.append(' ');
        buffer.append(' ');
        String id = each.getId();
        buffer.append(id);
        buffer.append('(');
        IParameterSpecification specification = each.getParameterSpecification();
        this.printOn(specification, buffer);
        buffer.append(')');
        this.printAvailabilityOn(each, buffer);
        buffer.append('.');
        buffer.append('\n');
    }

    private void printOn(IParameterSpecification parameterSpecification, StringBuffer buffer) {
        List<String> list = parameterSpecification.getIds();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            buffer.append(id);
            boolean more = iterator.hasNext();
            if (!more) continue;
            buffer.append(',');
            buffer.append(' ');
        }
    }

    private void printOn(List<ICommand<?>> list, StringBuffer buffer) {
        int count = list.size();
        String value = String.format("Registered Commands: %d\n", count);
        buffer.append(value);
        for (ICommand<?> each : list) {
            this.printOn(each, buffer);
        }
    }
}

