/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.command.validator;

import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.api.command.ParameterSpecificationException;
import com.sas.solstice.platform.application.common.command.validator.AbstractParameterValidator;

public class NumericParameterValidator
extends AbstractParameterValidator {
    private int min;
    private int max;

    public NumericParameterValidator() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public NumericParameterValidator(int min, int max) {
        if (max < min) {
            String message = String.format("the value of max (%d) must be greater than or equal to min (%d)", max, min);
            throw new IllegalArgumentException(message);
        }
        this.setMin(min);
        this.setMax(max);
    }

    private int getMax() {
        return this.max;
    }

    private int getMin() {
        return this.min;
    }

    private void setMax(int max) {
        this.max = max;
    }

    private void setMin(int min) {
        this.min = min;
    }

    private int toInt(String value, IParameterSpecification.IParameter parameter) throws ParameterSpecificationException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException exception) {
            String name = parameter.getName();
            String message = String.format("Input Error: The \"%s\" value \"%s\" is not a number.", name, value);
            throw new ParameterSpecificationException(message, exception);
        }
    }

    @Override
    public String validate(String value, IParameterSpecification.IParameter parameter) throws ParameterSpecificationException {
        int number = this.toInt(value, parameter);
        int min = this.getMin();
        int max = this.getMax();
        if (number < min || number > max) {
            String name = parameter.getName();
            String message = String.format("Input Error: The \"%s\" value %d is not within the range %d-%d.", name, number, min, max);
            throw new ParameterSpecificationException(message);
        }
        return value;
    }
}

