/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.command.validator;

import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.api.command.ParameterSpecificationException;
import com.sas.solstice.platform.application.common.command.validator.AbstractParameterValidator;
import com.sas.solstice.platform.application.common.command.validator.CompositeException;
import com.sas.solstice.platform.application.common.internal.util.GenericComposite;
import com.sas.solstice.platform.application.common.internal.util.StringUtility;
import com.sas.solstice.platform.application.common.internal.util.api.IGenericComposite;
import java.util.List;

public class CompositeParameterValidator
extends AbstractParameterValidator {
    private static final boolean DEFAULT_STRICT = true;
    private IGenericComposite<IParameterSpecification.IParameterValidator> composite;
    private boolean strict;

    public CompositeParameterValidator(boolean strict, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size must be a positive integer");
        }
        this.setStrict(strict);
        this.setComposite(this.createComposite(size));
    }

    public CompositeParameterValidator(boolean strict, IParameterSpecification.IParameterValidator ... validators) {
        this(strict, validators.length);
        this.addAll(validators);
    }

    public CompositeParameterValidator(int size) {
        this(true, size);
    }

    public CompositeParameterValidator(IParameterSpecification.IParameterValidator ... validators) {
        this(true, validators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(IParameterSpecification.IParameterValidator validator) {
        IGenericComposite<IParameterSpecification.IParameterValidator> composite = this.getComposite();
        CompositeParameterValidator compositeParameterValidator = this;
        synchronized (compositeParameterValidator) {
            return composite.add(validator);
        }
    }

    private void addAll(IParameterSpecification.IParameterValidator[] validators) {
        for (IParameterSpecification.IParameterValidator validator : validators) {
            this.add(validator);
        }
    }

    private GenericComposite<IParameterSpecification.IParameterValidator> createComposite(int size) {
        String name = this.getName();
        return new GenericComposite<IParameterSpecification.IParameterValidator>(name, size);
    }

    private IGenericComposite<IParameterSpecification.IParameterValidator> getComposite() {
        return this.composite;
    }

    private String getName() {
        return CompositeParameterValidator.class.getSimpleName();
    }

    private List<IParameterSpecification.IParameterValidator> getValidators() {
        IGenericComposite<IParameterSpecification.IParameterValidator> composite = this.getComposite();
        return composite.getComposables();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    private boolean isStrict() {
        return this.strict;
    }

    private String performLenientValidation(String value, IParameterSpecification.IParameter parameter) throws ParameterSpecificationException {
        boolean valid;
        List<IParameterSpecification.IParameterValidator> validators = this.getValidators();
        int validatorsSize = validators.size();
        if (validatorsSize == 0) {
            return value;
        }
        CompositeException compositeException = new CompositeException();
        String validValue = this.performLenientValidation(value, parameter, compositeException);
        int caughtExceptions = compositeException.size();
        boolean bl = valid = caughtExceptions != validatorsSize;
        if (!valid) {
            String name = parameter.getName();
            String message = String.format("lenient composite validator failed for the parameter \"%s\" with the value \"%s\"", name, value);
            throw new ParameterSpecificationException(message, compositeException);
        }
        return validValue;
    }

    private String performLenientValidation(String value, IParameterSpecification.IParameter parameter, CompositeException compositeException) {
        String validValue = value;
        List<IParameterSpecification.IParameterValidator> validators = this.getValidators();
        for (IParameterSpecification.IParameterValidator validator : validators) {
            try {
                validValue = validator.validate(validValue, parameter);
            }
            catch (ParameterSpecificationException exception) {
                compositeException.add(exception);
            }
        }
        return validValue;
    }

    private String performStrictValidation(String value, IParameterSpecification.IParameter parameter) throws ParameterSpecificationException {
        String validValue = value;
        List<IParameterSpecification.IParameterValidator> validators = this.getValidators();
        for (IParameterSpecification.IParameterValidator validator : validators) {
            validValue = validator.validate(validValue, parameter);
        }
        return validValue;
    }

    private void printOn(StringBuffer buffer) {
        this.printStrictOn(buffer);
    }

    private void printStrictOn(StringBuffer buffer) {
        boolean strict = this.isStrict();
        String value = StringUtility.toFormattedBinaryString("strict", strict);
        buffer.append(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IParameterSpecification.IParameterValidator validator) {
        IGenericComposite<IParameterSpecification.IParameterValidator> composite = this.getComposite();
        CompositeParameterValidator compositeParameterValidator = this;
        synchronized (compositeParameterValidator) {
            return composite.remove(validator);
        }
    }

    private void setComposite(IGenericComposite<IParameterSpecification.IParameterValidator> composite) {
        this.composite = composite;
    }

    private void setStrict(boolean strict) {
        this.strict = strict;
    }

    public int size() {
        IGenericComposite<IParameterSpecification.IParameterValidator> composite = this.getComposite();
        return composite.size();
    }

    public String toString() {
        String value = super.toString();
        StringBuffer buffer = new StringBuffer(150);
        buffer.append(value);
        this.printOn(buffer);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validate(String value, IParameterSpecification.IParameter parameter) throws ParameterSpecificationException {
        boolean strict = this.isStrict();
        if (strict) {
            CompositeParameterValidator compositeParameterValidator = this;
            synchronized (compositeParameterValidator) {
                return this.performStrictValidation(value, parameter);
            }
        }
        CompositeParameterValidator compositeParameterValidator = this;
        synchronized (compositeParameterValidator) {
            return this.performLenientValidation(value, parameter);
        }
    }
}

