/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.command.validator;

import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.api.command.ParameterSpecificationException;
import com.sas.solstice.platform.application.common.command.validator.AbstractParameterValidator;
import java.util.Locale;

public class BooleanParameterValidator
extends AbstractParameterValidator {
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();

    private boolean isNo(String value) {
        String normalValue = this.normalize(value);
        if ("no".equals(normalValue)) {
            return true;
        }
        if ("false".equals(normalValue)) {
            return true;
        }
        if ("n".equals(normalValue)) {
            return true;
        }
        return "f".equals(normalValue);
    }

    private boolean isYes(String value) {
        String normalValue = this.normalize(value);
        if ("yes".equals(normalValue)) {
            return true;
        }
        if ("true".equals(normalValue)) {
            return true;
        }
        if ("y".equals(normalValue)) {
            return true;
        }
        return "t".equals(normalValue);
    }

    private String normalize(String value) {
        if (value == null) {
            return null;
        }
        String normalValue = value.trim();
        normalValue = normalValue.toLowerCase(Locale.US);
        return normalValue;
    }

    @Override
    public String validate(String value, IParameterSpecification.IParameter parameter) throws ParameterSpecificationException {
        if (this.isYes(value)) {
            return TRUE;
        }
        if (this.isNo(value)) {
            return FALSE;
        }
        String message = String.format("Input Error: \"%s\" is not a valid value.", value);
        throw new ParameterSpecificationException(message);
    }
}

