/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common.command;

import com.sas.solstice.platform.application.common.DefaultAvailabilityPolicy;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.IAvailabilityPolicy;
import com.sas.solstice.platform.application.common.api.command.CommandExecutionException;
import com.sas.solstice.platform.application.common.api.command.ICommand;
import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.command.parameter.ParameterSpecification;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;

public abstract class AbstractCommand<T extends IApplicationModel>
implements ICommand<T> {
    private static final String SUFFIX = "Command";
    private IAvailabilityPolicy<ICommand<T>> availabilityPolicy;

    protected void buildParameterSpecification(IParameterSpecification specification) {
    }

    @Override
    public int compareTo(ICommand<T> command) {
        String id = this.getId();
        String commandId = command.getId();
        return id.compareTo(commandId);
    }

    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            return true;
        }
        if (!(object instanceof ICommand)) {
            return false;
        }
        ICommand<T> command = this.toCommand(object);
        String thisId = this.getId();
        String thatId = command.getId();
        return thisId.equals(thatId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAvailabilityPolicy<ICommand<T>> getAvailabilityPolicy() {
        AbstractCommand abstractCommand = this;
        synchronized (abstractCommand) {
            if (this.availabilityPolicy == null) {
                this.setAvailabilityPolicy(new DefaultAvailabilityPolicy<ICommand<T>>());
            }
            return this.availabilityPolicy;
        }
    }

    @Override
    public String getDecoration() {
        return null;
    }

    protected final String getDefaultUsage() {
        return String.format("The \"%s\" command.", this.getId());
    }

    @Override
    public String getId() {
        return this.getShortName();
    }

    private String getName() {
        Class<?> clazz = this.getClass();
        return clazz.getSimpleName();
    }

    @Override
    public final IParameterSpecification getParameterSpecification() {
        ParameterSpecification specification = new ParameterSpecification();
        this.buildParameterSpecification(specification);
        return specification;
    }

    @Override
    public final String getParentId() {
        return null;
    }

    private int getRandomNumber(int maximum) {
        Random random = new Random();
        return random.nextInt(maximum) + 1;
    }

    private String getShortName() {
        String name = this.getName();
        return this.toShortName(name);
    }

    @Override
    public String getUsage() {
        return this.getDefaultUsage();
    }

    protected final void handleException(Exception exception) throws CommandExecutionException {
        String id = this.getId();
        String message = String.format("The command \"%s\" failed to execute", id);
        this.handleExeception(message, exception);
    }

    protected void handleExeception(String message, Exception exception) throws CommandExecutionException {
        throw new CommandExecutionException(message, exception);
    }

    public int hashCode() {
        String id = this.getId();
        return id.hashCode();
    }

    @Override
    public boolean isAvailable() {
        IAvailabilityPolicy<ICommand<AbstractCommand>> policy = this.getAvailabilityPolicy();
        return policy.isAvailable(this);
    }

    private boolean isNameConventional(String name) {
        return name.endsWith(SUFFIX);
    }

    private String removeSuffix(String name) {
        int nameLength = name.length();
        int stopIndex = nameLength - SUFFIX.length();
        return name.substring(0, stopIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAvailabilityPolicy(IAvailabilityPolicy<ICommand<T>> availabilityPolicy) {
        AbstractCommand abstractCommand = this;
        synchronized (abstractCommand) {
            this.availabilityPolicy = availabilityPolicy;
        }
    }

    @Override
    public void setParentId(String parentId) {
        this.signalCommandsDoNotFormHierarchies();
    }

    private void signalCommandsDoNotFormHierarchies() {
        throw new UnsupportedOperationException("ICommand instances do not form hierarchies!");
    }

    private ICommand<T> toCommand(Object object) {
        return (ICommand)object;
    }

    protected final String toSensitiveString(String value) {
        if (value == null) {
            return null;
        }
        int length = 5 + this.getRandomNumber(10);
        char[] chars = new char[length];
        Arrays.fill(chars, '*');
        return new String(chars);
    }

    private String toShortName(String name) {
        String result = name;
        boolean conventional = this.isNameConventional(name);
        if (conventional) {
            result = this.removeSuffix(name);
        }
        return result.toLowerCase(Locale.US);
    }
}

