/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common;

import com.sas.solstice.platform.application.common.api.IServiceManager;
import com.sas.solstice.platform.application.common.api.IServiceMetadataFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServiceManager
implements IServiceManager {
    private IServiceMetadataFactory factory;
    private Map<String, IServiceMetadataFactory.IServiceMetadata<?>> services;
    private boolean started;

    public ServiceManager(IServiceMetadataFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.setFactory(factory);
        this.setServices(new HashMap(7));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T acquire(String name) {
        ServiceManager serviceManager = this;
        synchronized (serviceManager) {
            this.checkStarted();
            return this.acquireService(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T acquireService(String name) {
        Map<String, IServiceMetadataFactory.IServiceMetadata<?>> services;
        this.checkName(name);
        Map<String, IServiceMetadataFactory.IServiceMetadata<?>> map = services = this.getServices();
        synchronized (map) {
            IServiceMetadataFactory.IServiceMetadata<Object> metadata = services.get(name);
            if (metadata == null) {
                metadata = this.createServiceMetadata(name);
                metadata.acquire();
                services.put(name, metadata);
            }
            return this.getService(metadata);
        }
    }

    private void checkName(String name) {
        if (name != null) {
            return;
        }
        throw new IllegalArgumentException("name must not be null");
    }

    private void checkStarted() {
        boolean started = this.isStarted();
        if (started) {
            return;
        }
        throw new IllegalStateException("the service manager must be started");
    }

    private <T> IServiceMetadataFactory.IServiceMetadata<T> createServiceMetadata(String name) {
        IServiceMetadataFactory factory = this.getFactory();
        return factory.createServiceMetadata(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getAllServiceNames() {
        Map<String, IServiceMetadataFactory.IServiceMetadata<?>> services;
        Map<String, IServiceMetadataFactory.IServiceMetadata<?>> map = services = this.getServices();
        synchronized (map) {
            Set<String> set = services.keySet();
            return new ArrayList<String>(set);
        }
    }

    private IServiceMetadataFactory getFactory() {
        return this.factory;
    }

    private <T> T getService(IServiceMetadataFactory.IServiceMetadata<?> metadata) {
        return (T)metadata.acquire();
    }

    private Map<String, IServiceMetadataFactory.IServiceMetadata<?>> getServices() {
        return this.services;
    }

    private boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release(String name) {
        ServiceManager serviceManager = this;
        synchronized (serviceManager) {
            this.checkStarted();
            return this.releaseService(name);
        }
    }

    private void releaseAllServices() {
        List<String> names = this.getAllServiceNames();
        for (String name : names) {
            this.release(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean releaseService(String name) {
        Map<String, IServiceMetadataFactory.IServiceMetadata<?>> services;
        this.checkName(name);
        Map<String, IServiceMetadataFactory.IServiceMetadata<?>> map = services = this.getServices();
        synchronized (map) {
            IServiceMetadataFactory.IServiceMetadata<?> metadata = services.remove(name);
            if (metadata == null) {
                return false;
            }
            return metadata.release();
        }
    }

    private void setFactory(IServiceMetadataFactory factory) {
        this.factory = factory;
    }

    private void setServices(Map<String, IServiceMetadataFactory.IServiceMetadata<?>> services) {
        this.services = services;
    }

    private void setStarted(boolean started) {
        this.started = started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start() {
        ServiceManager serviceManager = this;
        synchronized (serviceManager) {
            if (this.isStarted()) {
                return false;
            }
            this.setStarted(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stop() {
        ServiceManager serviceManager = this;
        synchronized (serviceManager) {
            if (!this.isStarted()) {
                return false;
            }
            this.releaseAllServices();
            this.setStarted(false);
        }
        return true;
    }
}

