/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common;

import com.sas.solstice.platform.application.common.api.IAvailabilityPolicy;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class PlatformAvailabilityPolicy<T>
implements IAvailabilityPolicy<T> {
    public static final String OS_NAME_PROPERTY = "os.name";
    public static final String WINDOWS = "Win";
    public static final String LINUX = "Lin";
    public static final String MAC = "Mac";
    public static final String ZOS = "z/OS";
    public static final String SUN = "Sun";
    public static final String AIX = "AIX";
    public static final String H6I = "HP";
    private List<String> platforms;
    private static final String NULL_ARG = "%s must not be null";

    public PlatformAvailabilityPolicy(EnumSet<SupportedPlatforms> platformSet) {
        if (platformSet == null) {
            String msg = String.format(NULL_ARG, "platformSet");
            throw new IllegalArgumentException(msg);
        }
        if (platformSet.isEmpty()) {
            throw new IllegalArgumentException("platformSet must not be empty");
        }
        int capacity = 7;
        ArrayList<String> platforms = new ArrayList<String>(capacity);
        if (platformSet.contains((Object)SupportedPlatforms.WINDOWS)) {
            platforms.add(WINDOWS);
        }
        if (platformSet.contains((Object)SupportedPlatforms.UNIX)) {
            platforms.add(AIX);
            platforms.add(H6I);
            platforms.add(LINUX);
            platforms.add(MAC);
            platforms.add(SUN);
            platforms.add(ZOS);
        }
        this.setPlatforms(platforms);
    }

    public PlatformAvailabilityPolicy(String ... platforms) {
        if (platforms == null) {
            String msg = String.format(NULL_ARG, "platforms");
            throw new IllegalArgumentException(msg);
        }
        this.setPlatforms(new ArrayList<String>(platforms.length));
        this.addAll(platforms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAll(String[] platforms) {
        List<String> list;
        List<String> list2 = list = this.getPlatforms();
        synchronized (list2) {
            for (String platform : platforms) {
                list.add(platform);
            }
        }
    }

    private String getPlatformName() {
        return System.getProperty(OS_NAME_PROPERTY);
    }

    private List<String> getPlatforms() {
        return this.platforms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable(T resource) {
        List<String> platforms;
        String name = this.getPlatformName();
        if (name == null) {
            return true;
        }
        List<String> list = platforms = this.getPlatforms();
        synchronized (list) {
            for (String platform : platforms) {
                boolean match = this.isMatch(name, platform);
                if (!match) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMatch(String name, String platform) {
        return name.startsWith(platform);
    }

    private void setPlatforms(List<String> platforms) {
        this.platforms = platforms;
    }

    public static enum SupportedPlatforms {
        WINDOWS,
        UNIX;

    }
}

