/*
 * Decompiled with CFR 0.152.
 */
package com.sas.solstice.platform.application.common;

import com.sas.solstice.platform.application.common.Application;
import com.sas.solstice.platform.application.common.api.IApplication;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.command.ICommandProvider;
import com.sas.solstice.platform.application.common.api.menu.IMenuManager;
import com.sas.solstice.platform.application.common.api.menu.IMenuProvider;
import com.sas.solstice.platform.application.common.internal.command.CommandRegistry;
import com.sas.solstice.platform.application.common.internal.menu.MenuRegistry;
import com.sas.solstice.platform.application.common.menu.ConsoleMenuManager;

public class ConsoleApplication<T extends IApplicationModel>
implements IApplication {
    private static final int MENU_DEPTH_DEFAULT = 2;
    private IApplication application;

    public ConsoleApplication(T model, String ... arguments) {
        if (model == null) {
            throw new IllegalArgumentException("model must not be null");
        }
        IApplication application = this.createApplication(model, arguments);
        this.setApplication(application);
    }

    private IApplication createApplication(T model, String[] arguments) {
        IMenuManager menuManager = this.createMenuManager(model);
        return new Application<T>(model, menuManager, arguments);
    }

    private IMenuManager createMenuManager(T model) {
        String title = model.getName();
        ConsoleMenuManager manager = new ConsoleMenuManager(title, 2);
        ICommandProvider commandProvider = this.getCommandProvider();
        manager.setCommandProvider(commandProvider);
        IMenuProvider menuProvider = this.getMenuProvider();
        manager.setMenuProvider(menuProvider);
        return manager;
    }

    private IApplication getApplication() {
        return this.application;
    }

    private ICommandProvider getCommandProvider() {
        return CommandRegistry.getInstance();
    }

    private IMenuProvider getMenuProvider() {
        return MenuRegistry.getInstance();
    }

    private void setApplication(IApplication application) {
        this.application = application;
    }

    @Override
    public int start() {
        IApplication application = this.getApplication();
        return application.start();
    }

    @Override
    public int stop() {
        IApplication application = this.getApplication();
        return application.stop();
    }
}

