/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.servicewrapper.editor.internal;

import com.sas.deployment.servicewrapper.editor.IServiceWrapperEditor;
import com.sas.deployment.servicewrapper.editor.internal.ServiceWrapperEditor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class ServiceWrapperEditorProxy
implements IServiceWrapperEditor {
    private static final String FILENAME = "config/wrapper.conf";
    private static final String UTF_8 = "UTF-8";
    private ServiceWrapperEditor editor;

    public void activate() {
        this.editor = new ServiceWrapperEditor();
        Reader reader = this.createReader(FILENAME);
        if (reader == null) {
            return;
        }
        try {
            try {
                this.editor.load(reader);
            }
            finally {
                reader.close();
            }
        }
        catch (IOException exception) {
            this.handleException(exception);
        }
    }

    private InputStream createInputStream(String name) {
        try {
            return new FileInputStream(name);
        }
        catch (FileNotFoundException exception) {
            this.handleException(exception);
            return null;
        }
    }

    private OutputStream createOutputStream(String name) {
        try {
            return new FileOutputStream(name);
        }
        catch (FileNotFoundException exception) {
            this.handleException(exception);
            return null;
        }
    }

    private Reader createReader(String name) {
        InputStream inputStream = this.createInputStream(name);
        if (inputStream == null) {
            return null;
        }
        try {
            return new InputStreamReader(inputStream, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            this.handleException(e);
            return null;
        }
    }

    private Writer createWriter(String name) throws IOException {
        OutputStream outputStream = this.createOutputStream(name);
        if (outputStream == null) {
            return null;
        }
        return new OutputStreamWriter(outputStream, UTF_8);
    }

    public void deactivate() {
        this.editor.unload();
        this.editor = null;
    }

    @Override
    public String getProperty(String key) {
        return this.editor.getProperty(key);
    }

    private void handleException(Exception exception) {
        String message = exception.getMessage();
        String error = String.format("Error: %s", message);
        System.err.println(error);
    }

    @Override
    public String setProperty(String key, String value) {
        String previousValue = this.editor.setProperty(key, value);
        this.store();
        return previousValue;
    }

    private void store() {
        try {
            Writer writer = this.createWriter(FILENAME);
            if (writer == null) {
                return;
            }
            try {
                this.editor.store(writer);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException exception) {
            this.handleException(exception);
        }
    }
}

