/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.servicewrapper.editor.internal;

import com.sas.deployment.servicewrapper.editor.IServiceWrapperEditor;
import com.sas.deployment.servicewrapper.editor.internal.Block;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class ServiceWrapperEditor
implements IServiceWrapperEditor {
    private List<Block> _blocks = new ArrayList<Block>(15);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBlock(Block block) {
        List<Block> list = this._blocks;
        synchronized (list) {
            this._blocks.add(block);
        }
    }

    private Block createBlock(String key, String value) {
        String line = String.format("%s=%s", key, value);
        Block newBlock = new Block(line);
        return newBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block getBlockContainingProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        List<Block> list = this._blocks;
        synchronized (list) {
            for (Block block : this._blocks) {
                String value = block.getProperty(key);
                if (value == null) continue;
                return block;
            }
        }
        return null;
    }

    @Override
    public String getProperty(String key) {
        Block block = this.getBlockContainingProperty(key);
        if (block == null) {
            return null;
        }
        return block.getProperty(key);
    }

    private void insertPadding() {
        if (this._blocks.isEmpty()) {
            return;
        }
        int count = this._blocks.size();
        Block lastBlock = this._blocks.get(count - 1);
        if (!lastBlock.isEmpty()) {
            Block newBlock = new Block("");
            this.addBlock(newBlock);
        }
    }

    public void load(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String line = bufferedReader.readLine();
        Block block = null;
        while (line != null) {
            block = this.recordLine(line, block);
            line = bufferedReader.readLine();
        }
    }

    private Block recordLine(String line, Block block) {
        boolean added;
        if (block != null && (added = block.add(line))) {
            return block;
        }
        Block newBlock = new Block(line);
        this.addBlock(newBlock);
        return newBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setProperty(String key, String value) {
        Block block = this.getBlockContainingProperty(key);
        if (block != null) {
            return block.setProperty(key, value);
        }
        Block newBlock = this.createBlock(key, value);
        List<Block> list = this._blocks;
        synchronized (list) {
            this.insertPadding();
            this.addBlock(newBlock);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Writer writer) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        List<Block> list = this._blocks;
        synchronized (list) {
            for (Block block : this._blocks) {
                block.store(writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        List<Block> list = this._blocks;
        synchronized (list) {
            this._blocks.clear();
        }
    }
}

