/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.servicewrapper.editor.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Block {
    private List<String> _lines;

    Block(String line) {
        if (line == null) {
            throw new IllegalArgumentException("line must not be null");
        }
        this._lines = new ArrayList<String>(1);
        this.add(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean add(String line) {
        List<String> list = this._lines;
        synchronized (list) {
            if (this.isValid(line)) {
                return this._lines.add(line);
            }
        }
        return false;
    }

    private Pattern createPattern(String key) {
        return Pattern.compile('^' + key + "=(.*)$");
    }

    private boolean isValid(String line) {
        if (this._lines.isEmpty()) {
            return true;
        }
        if (this.isBlank(line)) {
            String lastLine = this.getLastLine();
            return this.isBlank(lastLine);
        }
        if (this.isHeaderDivide(line)) {
            String firstLine = this.getFirstLine();
            return this.isHeaderDivide(firstLine);
        }
        if (this.isComment(line)) {
            String lastLine = this.getLastLine();
            if (this.isComment(lastLine)) {
                return true;
            }
            if (this._lines.size() > 1 && this.isHeaderDivide(lastLine)) {
                return false;
            }
            return !this.isBlank(lastLine);
        }
        String lastLine = this.getLastLine();
        return !this.isBlank(lastLine) && !this.isHeaderDivide(lastLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFirstLine() {
        List<String> list = this._lines;
        synchronized (list) {
            if (this._lines.isEmpty()) {
                return null;
            }
            return this._lines.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLastLine() {
        List<String> list = this._lines;
        synchronized (list) {
            if (this._lines.isEmpty()) {
                return null;
            }
            int count = this._lines.size();
            return this._lines.get(count - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getProperty(String key) {
        Pattern pattern = this.createPattern(key);
        List<String> list = this._lines;
        synchronized (list) {
            for (String line : this._lines) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.matches()) continue;
                return matcher.group(1);
            }
        }
        return null;
    }

    private boolean isBlank(String line) {
        return line.trim().isEmpty();
    }

    private boolean isComment(String line) {
        return line.startsWith("# ");
    }

    boolean isEmpty() {
        String line = this.getFirstLine();
        return this.isBlank(line);
    }

    private boolean isHeaderDivide(String line) {
        return line.startsWith("#*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String setProperty(String key, String value) {
        Pattern pattern = this.createPattern(key);
        int index = 0;
        List<String> list = this._lines;
        synchronized (list) {
            for (String line : this._lines) {
                Matcher matcher = pattern.matcher(line);
                if (matcher.matches()) {
                    String element = String.format("%s=%s", key, value);
                    this._lines.set(index, element);
                    return matcher.group(1);
                }
                ++index;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(Writer writer) throws IOException {
        List<String> list = this._lines;
        synchronized (list) {
            for (String line : this._lines) {
                writer.write(line.toCharArray());
                writer.write(10);
            }
        }
    }
}

