/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.property.editor.internal;

import com.sas.deployment.property.editor.IPropertyEditor;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;

public class PropertyEditor
implements IPropertyEditor {
    private Properties properties = new Properties();

    private void checkKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
    }

    @Override
    public String getProperty(String key) {
        this.checkKey(key);
        return this.properties.getProperty(key);
    }

    public void load(Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        this.properties.load(reader);
    }

    @Override
    public String setProperty(String key, String value) {
        this.checkKey(key);
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        return (String)this.properties.setProperty(key, value);
    }

    public void store(Writer writer) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("writer must not be null");
        }
        this.properties.store(writer, null);
    }

    public void unload() {
        this.properties.clear();
    }
}

