/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.config.app.menus.internal;

import com.sas.solstice.platform.application.common.api.menu.IMenu;
import com.sas.solstice.platform.application.common.api.menu.IMenuRegistrar;
import com.sas.solstice.platform.application.common.menu.ConsoleMenu;
import java.util.ArrayList;
import java.util.List;

public class Component {
    private static final String CONTEXT_HINT = "com.sas.deployment.config.app.menus: Config";
    private static final String START_AGENT = "Start Agent";
    private static final String STOP_AGENT = "Stop Agent";
    private IMenuRegistrar registrar;
    private List<IMenu> menus;

    public void activate() {
        List<IMenu> menus = this.build();
        this.setMenus(menus);
        this.register();
    }

    private List<IMenu> build() {
        ArrayList<IMenu> menus = new ArrayList<IMenu>(5);
        this.buildConfigureMenu(menus);
        IMenu menu = this.createStartMenu();
        menus.add(menu);
        menu = this.createStopMenu();
        menus.add(menu);
        return menus;
    }

    private void buildConfigureMenu(List<IMenu> menus) {
        IMenu menu = this.createConfigureWindowsServiceMenu();
        menus.add(menu);
        this.buildConfigureWindowsServiceMenu(menu, menus);
    }

    private void buildConfigureWindowsServiceMenu(IMenu parent, List<IMenu> menus) {
        String parentId = parent.getId();
        IMenu menu = this.createSetServiceUser(parentId);
        menus.add(menu);
        menu = this.createSetAutoStartMenu(parentId);
        menus.add(menu);
        menu = this.createAddServiceMenu(parentId);
        menus.add(menu);
        menu = this.createRemoveServiceMenu(parentId);
        menus.add(menu);
    }

    private IMenu createAddServiceMenu(String parentId) {
        ConsoleMenu menu = new ConsoleMenu("addService", "Add Service");
        menu.setParentId(parentId);
        menu.setData(CONTEXT_HINT);
        return menu;
    }

    private IMenu createConfigureWindowsServiceMenu() {
        ConsoleMenu menu = new ConsoleMenu("configureWindowsService", "Configure Windows Service");
        menu.setParentId("configure");
        menu.setData(CONTEXT_HINT);
        return menu;
    }

    private IMenu createRemoveServiceMenu(String parentId) {
        ConsoleMenu menu = new ConsoleMenu("removeService", "Remove Service");
        menu.setParentId(parentId);
        menu.setData(CONTEXT_HINT);
        return menu;
    }

    private IMenu createSetAutoStartMenu(String parentId) {
        ConsoleMenu menu = new ConsoleMenu("setAutoStart", "Set Auto Start");
        menu.setParentId(parentId);
        menu.setData(CONTEXT_HINT);
        return menu;
    }

    private IMenu createSetServiceUser(String parentId) {
        ConsoleMenu menu = new ConsoleMenu("setServiceUser", "Set Service User");
        menu.setParentId(parentId);
        menu.setData(CONTEXT_HINT);
        return menu;
    }

    private IMenu createStartMenu() {
        ConsoleMenu menu = new ConsoleMenu("start", START_AGENT);
        menu.setData(CONTEXT_HINT);
        return menu;
    }

    private IMenu createStopMenu() {
        ConsoleMenu menu = new ConsoleMenu("stop", STOP_AGENT);
        menu.setData(CONTEXT_HINT);
        return menu;
    }

    public void deactivate() {
        this.unregister();
        this.destroy();
    }

    private void destroy() {
        this.setMenus(null);
    }

    private List<IMenu> getMenus() {
        return this.menus;
    }

    private IMenuRegistrar getRegistrar() {
        return this.registrar;
    }

    private void register() {
        List<IMenu> menus = this.getMenus();
        for (IMenu menu : menus) {
            this.register(menu);
        }
    }

    private void register(IMenu menu) {
        IMenuRegistrar registrar = this.getRegistrar();
        registrar.register(menu);
    }

    private void setMenus(List<IMenu> menus) {
        this.menus = menus;
    }

    public void setRegistrar(IMenuRegistrar registrar) {
        this.registrar = registrar;
    }

    private void unregister() {
        List<IMenu> menus = this.getMenus();
        for (IMenu menu : menus) {
            this.unregister(menu);
        }
    }

    private void unregister(IMenu menu) {
        IMenuRegistrar registrar = this.getRegistrar();
        registrar.unregister(menu);
    }
}

