/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.config.app.main;

import com.sas.deployment.agent.jmx.client.api.IAgentMBeanProvider;
import com.sas.deployment.agent.jmx.client.internal.AgentMBeanProvider;
import com.sas.deployment.common.control.AgentMBean;
import com.sas.deployment.config.app.main.api.IInstanceRegistry;
import com.sas.deployment.config.app.main.api.IStoppable;
import com.sas.deployment.property.editor.IPropertyEditor;
import com.sas.deployment.property.editor.internal.PropertyEditorProxy;
import com.sas.deployment.servicewrapper.editor.IServiceWrapperEditor;
import com.sas.deployment.servicewrapper.editor.internal.ServiceWrapperEditorProxy;
import com.sas.solstice.platform.application.common.api.command.ICommandProvider;
import com.sas.solstice.platform.application.common.api.command.ICommandRegistrar;
import com.sas.solstice.platform.application.common.api.menu.IMenuRegistrar;
import com.sas.solstice.platform.application.common.internal.command.CommandRegistry;
import com.sas.solstice.platform.application.common.internal.menu.MenuRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class InstanceRegistry
implements IInstanceRegistry {
    private static final int DEFAULT_SIZE = 15;
    private Map<Class<?>, Object> instances;
    private List<IStoppable> stoppables;

    InstanceRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStoppable(IStoppable stoppable) {
        InstanceRegistry instanceRegistry = this;
        synchronized (instanceRegistry) {
            List<IStoppable> stoppables = this.getStoppables();
            stoppables.add(stoppable);
        }
    }

    private <T> T create(Class<T> clazz) {
        if (clazz == IAgentMBeanProvider.class) {
            return (T)this.createAgentMBeanProvider();
        }
        if (clazz == ICommandProvider.class) {
            return (T)this.createCommandProvider();
        }
        if (clazz == ICommandRegistrar.class) {
            return (T)this.createCommandRegistrar();
        }
        if (clazz == IPropertyEditor.class) {
            return (T)this.createPropertyEditor();
        }
        if (clazz == IServiceWrapperEditor.class) {
            return (T)this.createServiceWrapperEditor();
        }
        if (clazz == IMenuRegistrar.class) {
            return (T)this.createMenuRegistrar();
        }
        return null;
    }

    private IAgentMBeanProvider createAgentMBeanProvider() {
        AgentMBeanProvider instance = new AgentMBeanProvider();
        AgentMBean localAgent = this.getAgentMBean();
        instance.setLocalAgent(localAgent);
        instance.start();
        this.addStoppable(() -> instance.stop());
        return instance;
    }

    private ICommandProvider createCommandProvider() {
        ICommandRegistrar instance = this.getCommandRegistrar();
        if (instance instanceof ICommandProvider) {
            return (ICommandProvider)((Object)instance);
        }
        return null;
    }

    private ICommandRegistrar createCommandRegistrar() {
        return new CommandRegistry();
    }

    private IMenuRegistrar createMenuRegistrar() {
        return new MenuRegistry();
    }

    private IPropertyEditor createPropertyEditor() {
        PropertyEditorProxy instance = new PropertyEditorProxy();
        instance.activate();
        this.addStoppable(() -> instance.deactivate());
        return instance;
    }

    private IServiceWrapperEditor createServiceWrapperEditor() {
        ServiceWrapperEditorProxy instance = new ServiceWrapperEditorProxy();
        instance.activate();
        this.addStoppable(() -> instance.deactivate());
        return instance;
    }

    private <T> T get(Class<T> clazz) {
        String name = clazz.getSimpleName();
        Map<Class<?>, Object> instances = this.getInstances();
        Object instance = instances.get(clazz);
        if (instance == null) {
            instance = this.create(clazz);
            if (instance == null) {
                this.log("Failed to created an instance of %s", name);
                return null;
            }
            instances.put(clazz, instance);
            this.log("Registered %s: %s", name, instance);
        }
        this.log("Getting %s: %s", name, instance);
        return (T)instance;
    }

    private AgentMBean getAgentMBean() {
        return null;
    }

    @Override
    public IAgentMBeanProvider getAgentMBeanProvider() {
        return this.get(IAgentMBeanProvider.class);
    }

    @Override
    public ICommandProvider getCommandProvider() {
        return this.get(ICommandProvider.class);
    }

    @Override
    public ICommandRegistrar getCommandRegistrar() {
        return this.get(ICommandRegistrar.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Class<?>, Object> getInstances() {
        InstanceRegistry instanceRegistry = this;
        synchronized (instanceRegistry) {
            if (this.instances == null) {
                HashMap instances = new HashMap(15);
                this.setInstances(instances);
            }
            return this.instances;
        }
    }

    @Override
    public IMenuRegistrar getMenuRegistrar() {
        return this.get(IMenuRegistrar.class);
    }

    @Override
    public IPropertyEditor getPropertyEditor() {
        return this.get(IPropertyEditor.class);
    }

    @Override
    public IServiceWrapperEditor getServiceWrapperEditor() {
        return this.get(IServiceWrapperEditor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IStoppable> getStoppables() {
        InstanceRegistry instanceRegistry = this;
        synchronized (instanceRegistry) {
            if (this.stoppables == null) {
                ArrayList<IStoppable> stoppables = new ArrayList<IStoppable>(15);
                this.setStoppables(stoppables);
            }
            return this.stoppables;
        }
    }

    private void log(String format, Object ... values) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInstances(Map<Class<?>, Object> instances) {
        InstanceRegistry instanceRegistry = this;
        synchronized (instanceRegistry) {
            this.instances = instances;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStoppables(List<IStoppable> stoppables) {
        InstanceRegistry instanceRegistry = this;
        synchronized (instanceRegistry) {
            this.stoppables = stoppables;
        }
    }

    @Override
    public void start() {
        this.log("started", new Object[0]);
    }

    @Override
    public void stop() {
        this.stopStoppables();
        this.setInstances(null);
        this.log("stopped", new Object[0]);
    }

    private void stopStoppables() {
        List<IStoppable> stoppables = this.getStoppables();
        for (IStoppable stoppable : stoppables) {
            this.log("stopping %s", stoppable);
            stoppable.stop();
        }
        this.setStoppables(null);
    }
}

