/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.config.app.main;

import com.sas.deployment.config.app.main.AgentConfigurationToolConsoleApplication;
import com.sas.deployment.config.app.main.CommandConfigurator;
import com.sas.deployment.config.app.main.InstanceRegistry;
import com.sas.deployment.config.app.main.MenuConfigurator;
import com.sas.deployment.config.app.main.api.IConfigurator;
import com.sas.deployment.config.app.main.api.IInstanceRegistry;
import com.sas.deployment.property.editor.IPropertyEditor;
import com.sas.deployment.servicewrapper.editor.IServiceWrapperEditor;
import com.sas.solstice.platform.application.common.api.command.ICommandProvider;
import com.sas.solstice.platform.application.common.api.command.ICommandRegistrar;
import com.sas.solstice.platform.application.common.api.menu.IMenuRegistrar;

public class AgentConfigurationToolMain {
    private IInstanceRegistry registry;

    public static void main(String[] args) {
        AgentConfigurationToolMain m = new AgentConfigurationToolMain();
        int rc = m.run(args);
        System.exit(rc);
    }

    private IConfigurator createCommandConfigurator() {
        ICommandProvider commandProvider = this.getCommandProvider();
        ICommandRegistrar commandRegistrar = this.getCommandRegistrar();
        IPropertyEditor propertyEditor = this.getPropertyEditor();
        IServiceWrapperEditor serviceWrapperEditor = this.getServiceWrapperEditor();
        return new CommandConfigurator(commandProvider, commandRegistrar, propertyEditor, serviceWrapperEditor);
    }

    private IConfigurator createMenuConfigurator() {
        IMenuRegistrar registrar = this.getMenuRegistrar();
        return new MenuConfigurator(registrar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICommandProvider getCommandProvider() {
        AgentConfigurationToolMain agentConfigurationToolMain = this;
        synchronized (agentConfigurationToolMain) {
            IInstanceRegistry registry = this.getRegistry();
            return registry.getCommandProvider();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICommandRegistrar getCommandRegistrar() {
        AgentConfigurationToolMain agentConfigurationToolMain = this;
        synchronized (agentConfigurationToolMain) {
            IInstanceRegistry registry = this.getRegistry();
            return registry.getCommandRegistrar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMenuRegistrar getMenuRegistrar() {
        AgentConfigurationToolMain agentConfigurationToolMain = this;
        synchronized (agentConfigurationToolMain) {
            IInstanceRegistry registry = this.getRegistry();
            return registry.getMenuRegistrar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPropertyEditor getPropertyEditor() {
        AgentConfigurationToolMain agentConfigurationToolMain = this;
        synchronized (agentConfigurationToolMain) {
            IInstanceRegistry registry = this.getRegistry();
            return registry.getPropertyEditor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IInstanceRegistry getRegistry() {
        AgentConfigurationToolMain agentConfigurationToolMain = this;
        synchronized (agentConfigurationToolMain) {
            if (this.registry == null) {
                InstanceRegistry registry = new InstanceRegistry();
                registry.start();
                this.setRegistry(registry);
            }
            return this.registry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IServiceWrapperEditor getServiceWrapperEditor() {
        AgentConfigurationToolMain agentConfigurationToolMain = this;
        synchronized (agentConfigurationToolMain) {
            IInstanceRegistry registry = this.getRegistry();
            return registry.getServiceWrapperEditor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(String[] arguments) {
        IConfigurator commandConfigurator = this.createCommandConfigurator();
        IConfigurator menuConfigurator = this.createMenuConfigurator();
        AgentConfigurationToolConsoleApplication tool = new AgentConfigurationToolConsoleApplication();
        try {
            commandConfigurator.start();
            menuConfigurator.start();
            int n = tool.start(arguments);
            return n;
        }
        finally {
            tool.stop();
            menuConfigurator.stop();
            commandConfigurator.stop();
            this.stopRegistry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRegistry(IInstanceRegistry registry) {
        AgentConfigurationToolMain agentConfigurationToolMain = this;
        synchronized (agentConfigurationToolMain) {
            this.registry = registry;
        }
    }

    private void stopRegistry() {
        IInstanceRegistry registry = this.getRegistry();
        registry.stop();
        this.setRegistry(null);
    }
}

