/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.config.app.commands.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class StreamHandler {
    private static final Logger LOGGER = LogManager.getLogger(StreamHandler.class);
    private static final int DEFAULT_BUFFER_SIZE_BYTES = Integer.getInteger("com.sas.deployment.config.app.commands.internal.util.streamhandler.buffersize.bytes", 4096);
    private static final int REST_MS = Integer.getInteger("com.sas.deployment.config.app.commands.internal.util.streamhandler.rest.ms", 1000);
    private String name;
    private Thread thread;
    private InputStream inputStream;
    private OutputStream outputStream;
    private volatile boolean started;
    private int bufferSize;

    StreamHandler(String name, InputStream inputStream, OutputStream outputStream) {
        this(name, inputStream, outputStream, DEFAULT_BUFFER_SIZE_BYTES);
    }

    StreamHandler(String name, InputStream inputStream, OutputStream outputStream, int bufferSize) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        if (bufferSize < 512) {
            throw new IllegalArgumentException("bufferSize must be >= 512 bytes");
        }
        this.setName(name);
        this.setInputStream(inputStream);
        this.setOutputStream(outputStream);
        this.setBufferSize(bufferSize);
    }

    private Runnable createRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    StreamHandler.this.process();
                }
                catch (IOException exception) {
                    String message = exception.getMessage();
                    StreamHandler.this.logDebug(message);
                }
            }
        };
    }

    private Thread createThread() {
        Runnable runnable = this.createRunnable();
        String name = this.createThreadName();
        return new Thread(runnable, name);
    }

    private String createThreadName() {
        String prefix = StreamHandler.class.getSimpleName();
        String suffix = this.getName();
        return String.format("%s-%s", prefix, suffix);
    }

    private void delay(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int getBufferSize() {
        return this.bufferSize;
    }

    private InputStream getInputStream() {
        return this.inputStream;
    }

    private String getName() {
        return this.name;
    }

    private OutputStream getOutputStream() {
        return this.outputStream;
    }

    private Thread getThread() {
        return this.thread;
    }

    private boolean isStarted() {
        return this.started;
    }

    private void logDebug(byte[] buffer, int length) {
        String line = new String(buffer, 0, length);
        this.logDebug(line);
    }

    private void logDebug(String line) {
        LOGGER.debug(line);
    }

    private void logError(String line) {
        LOGGER.error(line);
    }

    private void process() throws IOException {
        int bufferSize = this.getBufferSize();
        byte[] buffer = new byte[bufferSize];
        InputStream inputStream = this.getInputStream();
        OutputStream outputStream = this.getOutputStream();
        while (this.isStarted()) {
            int length;
            while ((length = inputStream.read(buffer)) != -1) {
                if (outputStream != null) {
                    outputStream.write(buffer, 0, length);
                }
                this.logDebug(buffer, length);
            }
            this.delay(REST_MS);
        }
    }

    private void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    private void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStarted(boolean started) {
        StreamHandler streamHandler = this;
        synchronized (streamHandler) {
            this.started = started;
        }
    }

    private void setThread(Thread thread) {
        this.thread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        StreamHandler streamHandler = this;
        synchronized (streamHandler) {
            boolean started = this.isStarted();
            if (started) {
                return;
            }
            this.setStarted(true);
            this.startThread();
        }
    }

    private void startThread() {
        Thread thread = this.createThread();
        this.setThread(thread);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        StreamHandler streamHandler = this;
        synchronized (streamHandler) {
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            this.setStarted(false);
            this.stopThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThread() {
        Thread thread = this.getThread();
        thread.interrupt();
        try {
            thread.join();
        }
        catch (InterruptedException exception) {
            String message = exception.getMessage();
            this.logError(message);
        }
        finally {
            this.setThread(null);
        }
    }
}

