/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.config.app.commands.internal.util;

import com.sas.deployment.config.app.commands.internal.util.StreamHandler;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessStreamHandler {
    private static final Logger LOGGER = LogManager.getLogger(ProcessStreamHandler.class);
    private Process process;
    private StreamHandler standardOutputStreamHandler;
    private StreamHandler standardErrorStreamHandler;

    public ProcessStreamHandler(Process process, OutputStream stdoutStream, OutputStream stderrStream) {
        if (process == null) {
            throw new IllegalArgumentException("process must not be null");
        }
        this.setProcess(process);
        this.setStandardOutputStreamHandler(this.createStandardOutputStreamHandler(stdoutStream));
        this.setErrorStreamHandler(this.createStandardErrorStreamHandler(stderrStream));
    }

    private void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException exception) {
            String message = exception.getMessage();
            this.log(message);
        }
    }

    private void closeStandardErrorStream() {
        InputStream closeable = this.getStandardErrorStream();
        this.close(closeable);
    }

    private void closeStandardInputStream() {
        OutputStream closeable = this.getStandardInputStream();
        this.close(closeable);
    }

    private void closeStandardOutputStream() {
        InputStream closeable = this.getStandardOutputStream();
        this.close(closeable);
    }

    private StreamHandler createStandardErrorStreamHandler(OutputStream outputStream) {
        InputStream inputStream = this.getStandardErrorStream();
        return new StreamHandler("ErrorStream", inputStream, outputStream);
    }

    private StreamHandler createStandardOutputStreamHandler(OutputStream outputStream) {
        InputStream inputStream = this.getStandardOutputStream();
        return new StreamHandler("InputStream", inputStream, outputStream);
    }

    private Process getProcess() {
        return this.process;
    }

    private InputStream getStandardErrorStream() {
        Process process = this.getProcess();
        return process.getErrorStream();
    }

    private StreamHandler getStandardErrorStreamHandler() {
        return this.standardErrorStreamHandler;
    }

    private OutputStream getStandardInputStream() {
        Process process = this.getProcess();
        return process.getOutputStream();
    }

    private InputStream getStandardOutputStream() {
        Process process = this.getProcess();
        return process.getInputStream();
    }

    private StreamHandler getStandardOutputStreamHandler() {
        return this.standardOutputStreamHandler;
    }

    private void log(String line) {
        LOGGER.error(line);
    }

    private void setErrorStreamHandler(StreamHandler standardErrorStreamHandler) {
        this.standardErrorStreamHandler = standardErrorStreamHandler;
    }

    private void setProcess(Process process) {
        this.process = process;
    }

    private void setStandardOutputStreamHandler(StreamHandler standardOutputStreamHandler) {
        this.standardOutputStreamHandler = standardOutputStreamHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ProcessStreamHandler processStreamHandler = this;
        synchronized (processStreamHandler) {
            this.closeStandardInputStream();
            this.startStreamHandlers();
        }
    }

    private void startStreamHandlers() {
        StreamHandler stdoutStreamHandler = this.getStandardOutputStreamHandler();
        stdoutStreamHandler.start();
        StreamHandler stderrStreamHandler = this.getStandardErrorStreamHandler();
        stderrStreamHandler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ProcessStreamHandler processStreamHandler = this;
        synchronized (processStreamHandler) {
            this.closeStandardOutputStream();
            this.closeStandardErrorStream();
            this.stopStreamHandlers();
        }
    }

    private void stopStreamHandlers() {
        StreamHandler inputStreamHandler = this.getStandardOutputStreamHandler();
        inputStreamHandler.stop();
        StreamHandler errorStreamHandler = this.getStandardErrorStreamHandler();
        errorStreamHandler.stop();
    }
}

