/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.config.app.commands.internal.unix;

import com.sas.deployment.config.app.commands.internal.unix.AbstractUnixShellCommand;
import com.sas.deployment.config.app.commands.internal.unix.CommandUtils;

public abstract class AbstractShellScriptCommand
extends AbstractUnixShellCommand {
    private String scriptName;
    private String workingDirectory;

    protected String buildScriptName() {
        String value = this.getScriptName();
        value = String.format("./%s", value);
        return value;
    }

    protected String buildWorkingDirectory() {
        String value = this.getWorkingDirectory();
        return String.format("'%s'", value);
    }

    abstract String getDefaultScriptName();

    protected String getDefaultWorkingDirectory() {
        String defaultDir = this.getSystemProperty("user.dir");
        String dir = CommandUtils.getSystemProperty("solstice.agent.dir", defaultDir);
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScriptName() {
        AbstractShellScriptCommand abstractShellScriptCommand = this;
        synchronized (abstractShellScriptCommand) {
            if (this.scriptName == null) {
                String value = this.getDefaultScriptName();
                this.setScriptName(value);
            }
            return this.scriptName;
        }
    }

    protected String getSystemProperty(String key) {
        return CommandUtils.getSystemProperty(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWorkingDirectory() {
        AbstractShellScriptCommand abstractShellScriptCommand = this;
        synchronized (abstractShellScriptCommand) {
            if (this.workingDirectory == null) {
                String value = this.getDefaultWorkingDirectory();
                this.setWorkingDirectory(value);
            }
            return this.workingDirectory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScriptName(String value) {
        AbstractShellScriptCommand abstractShellScriptCommand = this;
        synchronized (abstractShellScriptCommand) {
            this.scriptName = this.validateProperty(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkingDirectory(String workingDirectory) {
        AbstractShellScriptCommand abstractShellScriptCommand = this;
        synchronized (abstractShellScriptCommand) {
            this.workingDirectory = this.validateProperty(workingDirectory);
        }
    }

    private String validateProperty(String value) {
        return CommandUtils.validateProperty(value);
    }
}

