/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.config.app.commands.internal;

import com.sas.deployment.agent.jmx.client.api.IAgentMBeanProvider;
import com.sas.deployment.config.app.commands.internal.SetAutoStartCommand;
import com.sas.deployment.config.app.commands.internal.windows.AddServiceCommand;
import com.sas.deployment.config.app.commands.internal.windows.RemoveServiceCommand;
import com.sas.deployment.config.app.commands.internal.windows.SetServiceUserCommand;
import com.sas.deployment.config.app.commands.internal.windows.StartCommand;
import com.sas.deployment.config.app.commands.internal.windows.StopCommand;
import com.sas.deployment.property.editor.IPropertyEditor;
import com.sas.deployment.servicewrapper.editor.IServiceWrapperEditor;
import com.sas.solstice.platform.application.common.PlatformAvailabilityPolicy;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.IAvailabilityPolicy;
import com.sas.solstice.platform.application.common.api.command.ICommand;
import com.sas.solstice.platform.application.common.api.command.ICommandRegistrar;
import com.sas.solstice.platform.application.common.command.AbstractCommand;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class Component {
    private IServiceWrapperEditor serviceWrapperEditor;
    private IPropertyEditor propertyEditor;
    private ICommandRegistrar commandRegistrar;
    private IAgentMBeanProvider agentMBeanProvider;
    private List<ICommand<?>> commands;

    public void activate() {
        List<ICommand<?>> commands = this.build();
        this.setCommands(commands);
        this.register();
    }

    private List<ICommand<?>> build() {
        IAvailabilityPolicy<ICommand<Object>> unixPolicy;
        IAvailabilityPolicy<ICommand<Object>> actWindowsPolicy;
        AbstractCommand command;
        ArrayList commands = new ArrayList(10);
        IAvailabilityPolicy<ICommand<Object>> windowsPolicy = this.createWindowsPlatformAvailabilityPolicy();
        if (windowsPolicy.isAvailable(null)) {
            IServiceWrapperEditor serviceWrapperEditor = this.getServiceWrapperEditor();
            command = new SetAutoStartCommand(serviceWrapperEditor);
            command.setAvailabilityPolicy(windowsPolicy);
            commands.add(command);
            command = new StartCommand();
            command.setAvailabilityPolicy(windowsPolicy);
            commands.add(command);
            command = new StopCommand();
            command.setAvailabilityPolicy(windowsPolicy);
            commands.add(command);
        }
        if ((actWindowsPolicy = this.createWindowsPlatformAvailabilityPolicy()).isAvailable(null)) {
            AbstractCommand actCommand = new SetServiceUserCommand();
            actCommand.setAvailabilityPolicy(actWindowsPolicy);
            commands.add(actCommand);
            actCommand = new AddServiceCommand();
            actCommand.setAvailabilityPolicy(actWindowsPolicy);
            commands.add(actCommand);
            actCommand = new RemoveServiceCommand();
            actCommand.setAvailabilityPolicy(actWindowsPolicy);
            commands.add(actCommand);
        }
        if ((unixPolicy = this.createUnixPlatformAvailabilityPolicy()).isAvailable(null)) {
            command = new com.sas.deployment.config.app.commands.internal.unix.StartCommand();
            command.setAvailabilityPolicy(unixPolicy);
            commands.add(command);
            command = new com.sas.deployment.config.app.commands.internal.unix.StopCommand();
            command.setAvailabilityPolicy(unixPolicy);
            commands.add(command);
        }
        return commands;
    }

    private IAvailabilityPolicy<ICommand<IApplicationModel>> createUnixPlatformAvailabilityPolicy() {
        EnumSet<PlatformAvailabilityPolicy.SupportedPlatforms> platforms = EnumSet.of(PlatformAvailabilityPolicy.SupportedPlatforms.UNIX);
        return new PlatformAvailabilityPolicy<ICommand<IApplicationModel>>(platforms);
    }

    private <T extends IApplicationModel> IAvailabilityPolicy<ICommand<T>> createWindowsPlatformAvailabilityPolicy() {
        EnumSet<PlatformAvailabilityPolicy.SupportedPlatforms> platforms = EnumSet.of(PlatformAvailabilityPolicy.SupportedPlatforms.WINDOWS);
        return new PlatformAvailabilityPolicy<ICommand<T>>(platforms);
    }

    public void deactivate() {
        this.unregister();
        this.destroy();
    }

    private void destroy() {
        this.setCommands(null);
    }

    IAgentMBeanProvider getAgentMBeanProvider() {
        return this.agentMBeanProvider;
    }

    private ICommandRegistrar getCommandRegistrar() {
        return this.commandRegistrar;
    }

    private List<ICommand<?>> getCommands() {
        return this.commands;
    }

    IPropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    private IServiceWrapperEditor getServiceWrapperEditor() {
        return this.serviceWrapperEditor;
    }

    private void register() {
        List<ICommand<?>> commands = this.getCommands();
        for (ICommand<?> command : commands) {
            this.register(command);
        }
    }

    private void register(ICommand<?> command) {
        ICommandRegistrar registrar = this.getCommandRegistrar();
        registrar.register(command);
    }

    public void setAgentMBeanProvider(IAgentMBeanProvider agentMBeanProvider) {
        this.agentMBeanProvider = agentMBeanProvider;
    }

    public void setCommandRegistrar(ICommandRegistrar commandRegistrar) {
        this.commandRegistrar = commandRegistrar;
    }

    private void setCommands(List<ICommand<?>> commands) {
        this.commands = commands;
    }

    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    public void setServiceWrapperEditor(IServiceWrapperEditor serviceWrapperEditor) {
        this.serviceWrapperEditor = serviceWrapperEditor;
    }

    private void unregister() {
        List<ICommand<?>> commands = this.getCommands();
        for (ICommand<?> command : commands) {
            this.unregister(command);
        }
    }

    private void unregister(ICommand<?> command) {
        ICommandRegistrar registrar = this.getCommandRegistrar();
        registrar.unregister(command);
    }
}

