/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.common.utilities;

public final class VersionUtilities {
    public static final String VERSION_DELIMITER = "\\.";

    public static int compareVersions(String version1, String version2) {
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 == null || version2 == null) {
            if (version1 != null) {
                return 1;
            }
            return -1;
        }
        if (version1.equals(version2)) {
            return 0;
        }
        String[] version1Parts = version1.split(VERSION_DELIMITER);
        String[] version2Parts = version2.split(VERSION_DELIMITER);
        int ia = version1Parts.length;
        int ib = version2Parts.length;
        int limit = Math.min(ia, ib);
        for (int i = 0; i < limit; ++i) {
            String a = version1Parts[i];
            String b = version2Parts[i];
            int c = VersionUtilities.compare(a, b);
            if (c == 0) continue;
            return c;
        }
        if (ia > ib) {
            return 1;
        }
        if (ia < ib) {
            return -1;
        }
        return 0;
    }

    private static int compare(String a, String b) {
        try {
            Float af = Float.valueOf(a);
            Float bf = Float.valueOf(b);
            return af.compareTo(bf);
        }
        catch (NumberFormatException e) {
            return a.compareTo(b);
        }
    }
}

