/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.common.utilities;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UrlBuilder {
    private static final char AMPERSAND = '&';
    private static final char QUESTION_MARK = '?';
    private static final String FORWARD_SLASH = "/";
    private String _spec;
    private List<UrlParameter> _parameters;

    public UrlBuilder(String spec) {
        if (spec == null) {
            throw new IllegalArgumentException("spec must not be null");
        }
        this._spec = spec;
        this._parameters = new ArrayList<UrlParameter>(5);
    }

    public void addParameter(String name, boolean value) {
        String valueString = String.valueOf(value);
        this.addParameter(name, valueString);
    }

    public void addParameter(String name, int value) {
        String valueString = String.valueOf(value);
        this.addParameter(name, valueString);
    }

    public void addParameter(String name, String value) {
        UrlParameter parameter = new UrlParameter(name, value);
        this.addParameter(parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addParameter(UrlParameter parameter) {
        List<UrlParameter> list = this._parameters;
        synchronized (list) {
            this._parameters.add(parameter);
        }
    }

    public void appendPath(String path) {
        boolean valid = this._spec.endsWith(FORWARD_SLASH);
        if (!valid) {
            this._spec = this.toString(this._spec, FORWARD_SLASH);
        }
        this._spec = this.toString(this._spec, path);
    }

    public String getPath() throws MalformedURLException {
        String answer = this.toUrl().getFile();
        if (!answer.startsWith(FORWARD_SLASH)) {
            answer = this.toString(FORWARD_SLASH, answer);
        }
        if (answer.endsWith(FORWARD_SLASH)) {
            answer = answer.substring(0, answer.length() - 1);
        }
        if (answer.length() == 0) {
            return FORWARD_SLASH;
        }
        return answer;
    }

    private void printOn(StringBuffer buffer) {
        buffer.append(this._spec);
        this.printParametersOn(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printParametersOn(StringBuffer buffer) {
        List<UrlParameter> list = this._parameters;
        synchronized (list) {
            boolean empty = this._parameters.isEmpty();
            if (empty) {
                return;
            }
            buffer.append('?');
            Iterator<UrlParameter> iterator = this._parameters.iterator();
            while (iterator.hasNext()) {
                UrlParameter parameter = iterator.next();
                parameter.printOn(buffer);
                boolean last = !iterator.hasNext();
                if (last) continue;
                buffer.append('&');
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(150);
        this.printOn(buffer);
        return buffer.toString();
    }

    private String toString(String left, String right) {
        String template = "%s%s";
        return String.format(template, left, right);
    }

    public URL toUrl() throws MalformedURLException {
        String value = this.toString();
        URL url = new URL(value);
        return url;
    }

    private static class UrlParameter {
        private static final char EQUALS = '=';
        private String name;
        private String value;

        UrlParameter(String name, String value) {
            if (name == null) {
                throw new IllegalArgumentException("name must not be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            this.name = name;
            this.value = value;
        }

        void printOn(StringBuffer buffer) {
            buffer.append(this.name);
            buffer.append('=');
            buffer.append(this.value);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(50);
            this.printOn(buffer);
            return buffer.toString();
        }
    }
}

