/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.common.utilities;

import com.sas.deployment.common.ext.CompositeInstallableExt;
import com.sas.deployment.common.ext.ContentExt;
import com.sas.deployment.common.ext.DeploymentDescriptorExt;
import com.sas.deployment.common.ext.ObjectFactoryExt;
import com.sas.deployment.common.ext.PackageDescriptorExt;
import com.sas.deployment.common.model.Composite;
import com.sas.deployment.common.model.DeploymentBooleanParameter;
import com.sas.deployment.common.model.DeploymentIntegerParameter;
import com.sas.deployment.common.model.DeploymentStringParameter;
import com.sas.deployment.common.model.DeploymentURIParameter;
import com.sas.deployment.common.model.Feature;
import com.sas.deployment.common.model.Language;
import com.sas.deployment.common.model.ObjectFactory;
import com.sas.deployment.common.model.OperatingSystem;
import com.sas.deployment.common.model.ParameterGroup;
import com.sas.deployment.common.model.Version;
import com.sas.deployment.common.model.generated.IComposite;
import com.sas.deployment.common.model.generated.IFeature;
import com.sas.deployment.common.model.generated.IOperatingSystem;
import com.sas.deployment.common.model.generated.IParameterGroup;
import com.sas.deployment.common.model.generated.IVersion;
import com.sas.deployment.common.store.IDatastore;
import com.sas.deployment.common.utilities.VersionUtilities;
import com.sas.solstice.platform.core.model.AlternativeRequirementType;
import com.sas.solstice.platform.core.model.BaseContentType;
import com.sas.solstice.platform.core.model.BooleanParameterType;
import com.sas.solstice.platform.core.model.CompositeInstallableType;
import com.sas.solstice.platform.core.model.CompositeUnitType;
import com.sas.solstice.platform.core.model.ContentElementReferenceType;
import com.sas.solstice.platform.core.model.ContentType;
import com.sas.solstice.platform.core.model.ContentsType;
import com.sas.solstice.platform.core.model.DerivedVariableType;
import com.sas.solstice.platform.core.model.DisplayTextType;
import com.sas.solstice.platform.core.model.ElementValueType;
import com.sas.solstice.platform.core.model.FeatureReferenceType;
import com.sas.solstice.platform.core.model.FeatureType;
import com.sas.solstice.platform.core.model.FeaturesType;
import com.sas.solstice.platform.core.model.IdentityType;
import com.sas.solstice.platform.core.model.InstallableUnitType;
import com.sas.solstice.platform.core.model.IntegerParameterType;
import com.sas.solstice.platform.core.model.LanguageSelectionsType;
import com.sas.solstice.platform.core.model.LanguageSetType;
import com.sas.solstice.platform.core.model.LanguageType;
import com.sas.solstice.platform.core.model.LanguagesType;
import com.sas.solstice.platform.core.model.MaxVersionType;
import com.sas.solstice.platform.core.model.NestedFeatureType;
import com.sas.solstice.platform.core.model.OptionalLanguagesType;
import com.sas.solstice.platform.core.model.PackageDescriptorType;
import com.sas.solstice.platform.core.model.PackageFeatureReferenceType;
import com.sas.solstice.platform.core.model.ParametersType;
import com.sas.solstice.platform.core.model.PropertyConstraintType;
import com.sas.solstice.platform.core.model.PropertyValueListType;
import com.sas.solstice.platform.core.model.ReferencedPackageType;
import com.sas.solstice.platform.core.model.RequirementResourceConstraintType;
import com.sas.solstice.platform.core.model.RequirementType;
import com.sas.solstice.platform.core.model.RequirementsType;
import com.sas.solstice.platform.core.model.ResourceType;
import com.sas.solstice.platform.core.model.SelectableContentType;
import com.sas.solstice.platform.core.model.StringParameterType;
import com.sas.solstice.platform.core.model.URIParameterType;
import com.sas.solstice.platform.core.model.VariablesGroupType;
import com.sas.solstice.platform.core.model.VariablesType;
import com.sas.solstice.platform.core.model.VersionConstraintType;
import com.sas.solstice.platform.core.model.VersionConstraintValueType;
import com.sas.solstice.platform.core.model.VersionRangeType;
import com.sas.solstice.platform.core.model.VersionValueType;
import com.sas.solstice.platform.utilities.FileUtilities;
import com.sas.solstice.platform.utilities.NetworkUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributionPointUtility {
    private static final String CONTEXT_PATH = "com.sas.solstice.platform.core.model";
    private static final String OBJECT_FACTORY_PROPERTY = "com.sun.xml.internal.bind.ObjectFactory";
    private static final String ORDER_NUMBER_NOT_FOUND = "The order number \"%s\" was not found.";
    private final URI _masterDP;
    private static final String CONTENTMANAGER_NOT_ORDER_EXCEPTION = "The Content provided must be for an order.";
    private static Unmarshaller unmarshaller = null;
    private static Marshaller marshaller = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributionPointUtility.class);
    private static final String MISSING_LOCATION = "A location must be provided to initialize a PackageDescriptor";
    private static final String MISSING_MASTER_LOC = String.format("The order server could not be found or could not be reached.  To specify the location of the order server, set the \"%s\" system property to the correct location (e.g. -D%s=http://rameses.unx.sas.com/sas/)", "solstice.masterdp", "solstice.masterdp");
    private static final String CUSTOMER_NOT_FOUND = String.format("An account for customer with ID {0} could not be found.  To specify a different customer ID, set the \"%s\" system property (e.g. -D%s=cust_112121)", "customerID", "customerID");
    private static final String CORRUPT_DP = "The distribution point being referenced at {0} is missing content or has an unexpected structure.  The operation could not be completed.";
    private static final String LOCATION_UNWRITEABLE = "The SAS deployment portal was unable to store local data at the given location:  {0}.  Please make sure that this location is writeable.";
    private final Map<String, String> _resourceMap;
    private final Map<String, IFeature> _featureRefs;
    private String _debugIndent = "";
    private ObjectFactory _commonModelObjectFactory = new ObjectFactory();

    private static JAXBContext createJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((String)CONTEXT_PATH);
    }

    private static Marshaller createMarshaller() throws JAXBException {
        JAXBContext context = DistributionPointUtility.createJAXBContext();
        Marshaller instance = context.createMarshaller();
        Object value = DistributionPointUtility.createObjectFactoryPropertyValue();
        instance.setProperty(OBJECT_FACTORY_PROPERTY, value);
        return instance;
    }

    private static Object createObjectFactoryPropertyValue() {
        return new Object[]{new ObjectFactoryExt()};
    }

    private static Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext context = DistributionPointUtility.createJAXBContext();
        Unmarshaller instance = context.createUnmarshaller();
        Object value = DistributionPointUtility.createObjectFactoryPropertyValue();
        instance.setProperty(OBJECT_FACTORY_PROPERTY, value);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Marshaller getMarshaller() throws JAXBException {
        Class<DistributionPointUtility> clazz = DistributionPointUtility.class;
        synchronized (DistributionPointUtility.class) {
            if (marshaller == null) {
                marshaller = DistributionPointUtility.createMarshaller();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return marshaller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Unmarshaller getUnmarshaller() throws JAXBException {
        Class<DistributionPointUtility> clazz = DistributionPointUtility.class;
        synchronized (DistributionPointUtility.class) {
            if (unmarshaller == null) {
                unmarshaller = DistributionPointUtility.createUnmarshaller();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return unmarshaller;
        }
    }

    public DistributionPointUtility(String dp) throws URISyntaxException, IOException {
        this._resourceMap = new HashMap<String, String>(17);
        this._featureRefs = new HashMap<String, IFeature>(17);
        String loc = dp;
        if (loc == null) {
            throw new IllegalStateException(MISSING_MASTER_LOC);
        }
        URI location = new URI(loc);
        String uriString = location.toString();
        String template = "%s/%s";
        URL customers = new URL(String.format(template, uriString, "customers"));
        URL orders = new URL(String.format(template, uriString, "orders"));
        URL releases = new URL(String.format(template, uriString, "products"));
        NetworkUtilities.checkIsValidUrl(customers);
        NetworkUtilities.checkIsValidUrl(orders);
        NetworkUtilities.checkIsValidUrl(releases);
        loc = dp;
        this._masterDP = new URI(loc);
    }

    private void addLanguagesToFeature(NestedFeatureType featureType, IFeature instance) {
        LanguageSelectionsType languages = featureType.getLanguages();
        if (languages == null) {
            return;
        }
        this.addMandatoryLanguagesToFeature(languages, instance);
        this.addOptionalLanguagesToFeature(languages, instance);
    }

    private void addLanguageToFeature(LanguageType languageType, IFeature feature, boolean required) {
        String type = languageType.getType();
        Language language = this._commonModelObjectFactory.createLanguage();
        language.setRequired(required);
        language.setType(type);
        feature.getLanguages().add(language);
    }

    private void addMandatoryLanguagesToFeature(LanguageSelectionsType languageSelections, IFeature feature) {
        LanguagesType languages = languageSelections.getMandatory();
        if (languages == null) {
            return;
        }
        List<LanguageType> list = languages.getLanguage();
        boolean required = true;
        for (LanguageType each : list) {
            this.addLanguageToFeature(each, feature, required);
        }
    }

    private void addOptionalLanguagesToFeature(LanguageSelectionsType languageSelections, IFeature feature) {
        OptionalLanguagesType languages = languageSelections.getOptional();
        if (languages == null) {
            return;
        }
        List<Serializable> list = languages.getLanguageOrLanguageSet();
        this.addOptionalLanguagesToFeature(list, feature);
    }

    private void addOptionalLanguagesToFeature(LanguageSetType languageSet, IFeature feature, boolean required) {
        List<LanguageType> list = languageSet.getLanguage();
        for (LanguageType each : list) {
            this.addLanguageToFeature(each, feature, required);
        }
    }

    private void addOptionalLanguagesToFeature(List<Serializable> list, IFeature feature) {
        boolean required = false;
        for (Serializable each : list) {
            if (each instanceof LanguageType) {
                LanguageType language = (LanguageType)each;
                this.addLanguageToFeature(language, feature, required);
                continue;
            }
            if (each instanceof LanguageSetType) {
                LanguageSetType languageSet = (LanguageSetType)each;
                this.addOptionalLanguagesToFeature(languageSet, feature, required);
                continue;
            }
            this.signalUnhandledObjectType(each);
        }
    }

    private void checkCanWriteToDirectory(File directory) throws IOException {
        boolean writeable = directory.canWrite();
        if (writeable) {
            return;
        }
        this.signalLocationIsUnwriteable(directory);
    }

    private void commit(IParameterGroup dbp, IDatastore datastore) {
        if (datastore == null) {
            return;
        }
        datastore.commit(dbp);
    }

    private IComposite createComposite(CompositeInstallableExt compositeInstallable, PackageDescriptorExt packageDescriptor) {
        Composite composite = this._commonModelObjectFactory.createComposite();
        String id = compositeInstallable.getId();
        composite.setCompositeID(id);
        IdentityType compositeIdentity = compositeInstallable.getIdentity();
        if (compositeIdentity != null) {
            DisplayTextType displayText = compositeIdentity.getName();
            String value = this.getValue(displayText, "noname");
            composite.setName(value);
            displayText = compositeIdentity.getDescription();
            value = this.getValue(displayText, "nodesc");
            composite.setDescription(value);
        }
        URI location = packageDescriptor.getLocation();
        String locationString = location.toString();
        composite.setURI(locationString);
        return composite;
    }

    public IFeature createFeature(NestedFeatureType nestedFeature) {
        if (nestedFeature == null) {
            throw new IllegalArgumentException("nestedFeature must not be null");
        }
        String id = nestedFeature.getId();
        Feature instance = this._commonModelObjectFactory.createFeature();
        instance.setFeatureId(id);
        DisplayTextType displayText = nestedFeature.getDisplayName();
        String value = this.getValue(displayText);
        instance.setName(value);
        this.addLanguagesToFeature(nestedFeature, instance);
        displayText = nestedFeature.getDescription();
        value = this.getValue(displayText);
        instance.setDescription(value);
        displayText = nestedFeature.getShortDescription();
        value = this.getValue(displayText);
        instance.setShortDescription(value);
        if (nestedFeature instanceof FeatureType) {
            FeatureType feature = (FeatureType)nestedFeature;
            boolean required = feature.isRequired();
            instance.setRequired(required);
        }
        return instance;
    }

    private void evaluateCompositeInstallable(IComposite composite, IDatastore datastore, IComposite topLevel, InstallableUnitType iu) {
        VariablesType variables = iu.getVariables();
        this.evaluateCompositeInstallables(composite, datastore, topLevel, variables);
    }

    public IComposite evaluateCompositeInstallable(DeploymentDescriptorExt dd, IComposite composite, CompositeInstallableExt compositeInstallable, IDatastore datastore, URI mirror, IComposite topLevel) throws URISyntaxException, IOException {
        if (compositeInstallable == null) {
            throw new IllegalArgumentException("compositeInstallable must not be null");
        }
        this.evaluateCompositeInstallableBaseContent(dd, composite, compositeInstallable, datastore, topLevel);
        SelectableContentType selectableContent = compositeInstallable.getSelectableContent();
        if (selectableContent == null) {
            return composite;
        }
        List<IFeature> compositeFeaturesList = composite.getFeatures();
        FeaturesType features = selectableContent.getFeatures();
        List<FeatureType> list = features.getFeature();
        for (FeatureType each : list) {
            IFeature feature = this.evaluateFeatureForComposite(each, datastore, mirror, topLevel);
            compositeFeaturesList.add(feature);
        }
        Map<String, IFeature> featureRefs = this.getFeatureRefs();
        Set<Map.Entry<String, IFeature>> set = featureRefs.entrySet();
        for (Map.Entry<String, IFeature> entry : set) {
            String key = entry.getKey();
            IFeature feature = this.findFeature(key, compositeFeaturesList);
            if (feature == null) continue;
            IFeature requiredFeature = entry.getValue();
            requiredFeature.getRequiredByFeatures().add(feature);
            feature.getRequiredFeatures().add(requiredFeature);
        }
        return composite;
    }

    private void evaluateReferencedBasePackage(ReferencedPackageType reference, DeploymentDescriptorExt dd, IComposite composite) {
        PackageDescriptorExt referencedPD = this.getPackageDescriptorExt(dd, reference);
        DeploymentDescriptorExt childDD = referencedPD.getDeploymentDescriptor();
        List<CompositeInstallableType> list = childDD.getCompositeInstallable();
        for (CompositeInstallableType c : list) {
            CompositeInstallableExt childCompositeInstallable = (CompositeInstallableExt)c;
            childCompositeInstallable.setDeploymentDescriptor(childDD);
            IComposite childComposite = this.createComposite(childCompositeInstallable, referencedPD);
            childComposite.setComposite(composite);
            composite.getComposites().add(childComposite);
        }
    }

    private void evaluateCompositeInstallableBaseContent(DeploymentDescriptorExt dd, IComposite composite, CompositeInstallableExt compositeInstallable, IDatastore datastore, IComposite topLevel) throws URISyntaxException, IOException {
        BaseContentType baseContent = compositeInstallable.getBaseContent();
        if (baseContent == null) {
            return;
        }
        List<Object> list = baseContent.getInstallableUnitOrConfigurationUnitOrCompositeUnit();
        for (Object each : list) {
            JAXBElement element = (JAXBElement)each;
            Object value = element.getValue();
            if (value instanceof ReferencedPackageType) {
                this.evaluateReferencedBasePackage((ReferencedPackageType)value, dd, composite);
                continue;
            }
            if (value instanceof InstallableUnitType) {
                InstallableUnitType iu = (InstallableUnitType)value;
                this.evaluateCompositeInstallable(composite, datastore, topLevel, iu);
                continue;
            }
            if (value instanceof CompositeUnitType) continue;
            this.signalUnhandledObjectType(value);
        }
    }

    private void evaluateCompositeInstallables(BaseContentType baseContent, IDatastore datastore, IFeature parent) {
        if (baseContent == null) {
            return;
        }
        List<Object> list = baseContent.getInstallableUnitOrConfigurationUnitOrCompositeUnit();
        for (Object each : list) {
            JAXBElement element = (JAXBElement)each;
            Object value = element.getValue();
            if (!(value instanceof InstallableUnitType)) continue;
            InstallableUnitType installableUnit = (InstallableUnitType)value;
            RequirementsType requirementsType = installableUnit.getRequirements();
            this.processRequirements(requirementsType, null, datastore, parent);
        }
    }

    private void evaluateCompositeInstallables(IComposite composite, IDatastore datastore, IComposite topLevel, VariablesType variables) {
        if (variables == null) {
            return;
        }
        List<VariablesGroupType> listOfVariableGroups = variables.getVariablesGroup();
        for (VariablesGroupType vgt : listOfVariableGroups) {
            List<Object> list = vgt.getParametersOrResourcePropertyOrDerivedVariable();
            for (Object each : list) {
                JAXBElement element = (JAXBElement)each;
                Object object = element.getValue();
                if (!(object instanceof ParametersType)) continue;
                ParametersType parameters = (ParametersType)object;
                this.evaluateCompositeInstallables(parameters, composite, topLevel, datastore);
            }
        }
    }

    public List<IComposite> evaluateCompositeInstallables(DeploymentDescriptorExt deploymentDescriptor, IDatastore datastore, URI mirror, IComposite topLevel, IFeature parent) throws URISyntaxException, IOException {
        if (deploymentDescriptor == null) {
            throw new IllegalArgumentException("desploymentDescriptor must not be null");
        }
        PackageDescriptorExt packageDescriptor = deploymentDescriptor.getPackageDescriptor();
        if (mirror != null) {
            this.synchronizeMirrorMetadataForPackageDescriptor(packageDescriptor, mirror);
        }
        ArrayList<IComposite> result = new ArrayList<IComposite>();
        List<CompositeInstallableType> list = deploymentDescriptor.getCompositeInstallable();
        for (CompositeInstallableType each : list) {
            CompositeInstallableExt compositeInstallable = (CompositeInstallableExt)each;
            compositeInstallable.setDeploymentDescriptor(deploymentDescriptor);
            IComposite composite = this.createComposite(compositeInstallable, packageDescriptor);
            if (topLevel == null) {
                topLevel = composite;
            }
            if (datastore != null) {
                datastore.commit(composite);
            }
            RequirementsType requirementsType = each.getRequirements();
            this.processRequirements(requirementsType, composite, datastore, parent);
            BaseContentType baseContent = each.getBaseContent();
            this.evaluateCompositeInstallables(baseContent, datastore, parent);
            composite = this.evaluateCompositeInstallable(deploymentDescriptor, composite, compositeInstallable, datastore, mirror, topLevel);
            VariablesType variables = compositeInstallable.getVariables();
            this.evaluateCompositeInstallables(composite, datastore, topLevel, variables);
            result.add(composite);
        }
        return result;
    }

    private void evaluateCompositeInstallables(ParametersType parameters, IComposite composite, IComposite topLevel, IDatastore datastore) {
        IParameterGroup listOfParameters = this.evaluateParameters(parameters, composite, topLevel, datastore);
        IParameterGroup embeddedParameters = topLevel.getEmbeddedParameters();
        if (embeddedParameters == null) {
            embeddedParameters = this._commonModelObjectFactory.createParameterGroup();
        }
        embeddedParameters.getIntegerParameterOrStringParameterOrBooleanParameter().addAll(listOfParameters.getIntegerParameterOrStringParameterOrBooleanParameter());
    }

    public IFeature evaluateFeatureForComposite(NestedFeatureType featureType, IDatastore datastore, URI mirror, IComposite topLevel) throws URISyntaxException, IOException {
        IFeature persistentFeature;
        if (datastore == null) {
            persistentFeature = this.createFeature(featureType);
        } else {
            persistentFeature = datastore.createFeature(featureType);
            datastore.commit(persistentFeature);
        }
        List<Serializable> list = featureType.getNestedFeatureOrContentElementOrPackageFeatureReference();
        for (Serializable each : list) {
            if (each instanceof ContentElementReferenceType) continue;
            if (each instanceof NestedFeatureType) {
                NestedFeatureType nestedChild = (NestedFeatureType)each;
                IFeature persistentChild = this.evaluateFeatureForComposite(nestedChild, datastore, mirror, topLevel);
                persistentFeature.getNestedFeatures().add(persistentChild);
                continue;
            }
            if (each instanceof PackageFeatureReferenceType) continue;
            if (each instanceof FeatureReferenceType) {
                FeatureReferenceType featureRef = (FeatureReferenceType)each;
                Object featureRefTarget = featureRef.getFeatureRef();
                String id = null;
                id = featureRefTarget instanceof FeatureType ? ((FeatureType)featureRefTarget).getId() : ((NestedFeatureType)featureRefTarget).getId();
                this.getFeatureRefs().put(id, persistentFeature);
                continue;
            }
            if (each instanceof DerivedVariableType) continue;
            this.signalUnhandledObjectType(each);
        }
        return persistentFeature;
    }

    public IParameterGroup evaluateParameters(ParametersType parameters, IComposite composite, IComposite topLevel, IDatastore datastore) {
        LOGGER.info("evaluating parameters");
        List<Object> list = parameters.getIntegerParameterOrStringParameterOrBooleanParameter();
        ParameterGroup result = this._commonModelObjectFactory.createParameterGroup();
        for (Object each : list) {
            JAXBElement element = (JAXBElement)each;
            Object object = element.getValue();
            if (object instanceof IntegerParameterType) {
                this.evaluateIntegerParameter(result, object);
                continue;
            }
            if (object instanceof StringParameterType) {
                this.evaluateStringParameter(result, object);
                continue;
            }
            if (object instanceof BooleanParameterType) {
                this.evaluateBooleanParameter(result, object);
                continue;
            }
            if (!(object instanceof URIParameterType)) continue;
            this.evaluateURIParameter(result, object);
        }
        this.commit(result, datastore);
        return result;
    }

    private void evaluateURIParameter(IParameterGroup result, Object object) {
        URIParameterType parameter = (URIParameterType)object;
        String id = parameter.getId();
        ElementValueType defaultElementValue = parameter.getDefaultValue();
        DeploymentURIParameter p = this._commonModelObjectFactory.createDeploymentURIParameter();
        if (defaultElementValue != null) {
            String value = defaultElementValue.getValue();
            p.setDefaultValue(value);
        }
        p.setName(id);
        result.getIntegerParameterOrStringParameterOrBooleanParameter().add(p);
    }

    private void evaluateBooleanParameter(IParameterGroup result, Object object) {
        BooleanParameterType parameter = (BooleanParameterType)object;
        String id = parameter.getId();
        ElementValueType defaultElementValue = parameter.getDefaultValue();
        DeploymentBooleanParameter p = this._commonModelObjectFactory.createDeploymentBooleanParameter();
        if (defaultElementValue != null) {
            String value = defaultElementValue.getValue();
            p.setDefaultValue(value);
        }
        p.setName(id);
        result.getIntegerParameterOrStringParameterOrBooleanParameter().add(p);
    }

    private void evaluateStringParameter(IParameterGroup result, Object object) {
        StringParameterType parameter = (StringParameterType)object;
        String id = parameter.getId();
        ElementValueType defaultElementValue = parameter.getDefaultValue();
        DeploymentStringParameter p = this._commonModelObjectFactory.createDeploymentStringParameter();
        if (defaultElementValue != null) {
            String value = defaultElementValue.getValue();
            p.setDefaultValue(value);
        }
        p.setName(id);
        result.getIntegerParameterOrStringParameterOrBooleanParameter().add(p);
    }

    private void evaluateIntegerParameter(IParameterGroup result, Object object) {
        IntegerParameterType parameter = (IntegerParameterType)object;
        String id = parameter.getId();
        ElementValueType defaultElementValue = parameter.getDefaultValue();
        DeploymentIntegerParameter p = this._commonModelObjectFactory.createDeploymentIntegerParameter();
        if (defaultElementValue != null) {
            String value = defaultElementValue.getValue();
            p.setDefaultValue(value);
        }
        p.setName(id);
        result.getIntegerParameterOrStringParameterOrBooleanParameter().add(p);
    }

    private IFeature findFeature(String id, List<IFeature> list) {
        IFeature feature = null;
        Iterator<IFeature> iterator = list.iterator();
        boolean match = false;
        while (!match && iterator.hasNext()) {
            feature = iterator.next();
            String featureId = feature.getFeatureId();
            match = featureId.equals(id);
        }
        return feature;
    }

    private String getCustomerId() {
        return System.getProperty("customerID");
    }

    public PackageDescriptorExt getCustomerRootPD(URI uri) throws IOException {
        LOGGER.debug("Package Descriptor " + uri);
        this._debugIndent = this._debugIndent + "\t";
        File rootDir = null;
        String customerID = this.getCustomerId();
        URI root = null;
        if (uri.equals(this._masterDP)) {
            String path = String.format("%s/%s/%s", "customers", customerID, "root_pd.xml");
            root = uri.resolve(path);
            try {
                URL url = root.toURL();
                NetworkUtilities.getStreamForURL(url);
            }
            catch (IOException e) {
                String message = MessageFormat.format(CUSTOMER_NOT_FOUND, customerID);
                throw new IOException(message, e);
            }
        } else {
            rootDir = new File(uri);
            File rootPD = new File(rootDir, "root_pd.xml");
            if (!rootPD.isFile()) {
                throw new IOException(MessageFormat.format(CORRUPT_DP, uri));
            }
            root = rootPD.toURI();
        }
        return this.loadPackageDescriptorFromDistributionPoint(uri, root);
    }

    public Map<String, IFeature> getFeatureRefs() {
        return this._featureRefs;
    }

    public URI getMasterDP() {
        return this._masterDP;
    }

    private IVersion getMaximumVersion(List<VersionRangeType> versionRanges) {
        Version maxVersion = null;
        if (versionRanges.isEmpty()) {
            return maxVersion;
        }
        Iterator<VersionRangeType> vIter = versionRanges.iterator();
        VersionRangeType firstVersionRange = vIter.next();
        if (firstVersionRange.getMaxVersion() != null) {
            maxVersion = this._commonModelObjectFactory.createVersion();
            MaxVersionType firstVersion = firstVersionRange.getMaxVersion();
            maxVersion.setInclusive(firstVersion.isInclusive());
            maxVersion.setValue(firstVersion.getValue());
        }
        while (vIter.hasNext()) {
            MaxVersionType currentVersion;
            VersionRangeType currentVersionRange = vIter.next();
            if (currentVersionRange.getMaxVersion() == null || VersionUtilities.compareVersions((currentVersion = currentVersionRange.getMaxVersion()).getValue(), maxVersion.getValue()) <= 0) continue;
            maxVersion.setValue(currentVersion.getValue());
            maxVersion.setInclusive(currentVersion.isInclusive());
        }
        return maxVersion;
    }

    private IVersion getMinimumVersion(List<VersionRangeType> versionRanges) {
        if (versionRanges.isEmpty()) {
            return null;
        }
        Iterator<VersionRangeType> vIter = versionRanges.iterator();
        VersionRangeType firstVersionRange = vIter.next();
        Version minVersion = this._commonModelObjectFactory.createVersion();
        if (firstVersionRange.getMinVersion() != null) {
            String firstVersion = firstVersionRange.getMinVersion();
            minVersion.setValue(firstVersion);
        }
        while (vIter.hasNext()) {
            String currentVersion;
            VersionRangeType currentVersionRange = vIter.next();
            if (currentVersionRange.getMinVersion() == null || VersionUtilities.compareVersions(currentVersion = currentVersionRange.getMinVersion(), minVersion.getValue()) >= 0) continue;
            minVersion.setValue(currentVersion);
        }
        return minVersion;
    }

    private IOperatingSystem getOperatingSystem(IDatastore datastore, String osName) {
        OperatingSystem os = null;
        if (datastore != null && (os = datastore.operatingSystemForName(osName)) != null) {
            return os;
        }
        os = this._commonModelObjectFactory.createOperatingSystem();
        os.setName(osName);
        if (datastore != null) {
            datastore.commit(os);
        }
        return os;
    }

    private List<String> getOperatingSystemNames(PropertyConstraintType osConstraint) {
        ArrayList<String> osNames = new ArrayList<String>(3);
        QName qname = osConstraint.getPropertyName();
        String name = qname.getLocalPart();
        boolean match = name.equals("OperatingSystem.OSType");
        if (!match) {
            return osNames;
        }
        ElementValueType evt = osConstraint.getValue();
        if (evt != null) {
            String value = evt.getValue();
            osNames.add(value);
            return osNames;
        }
        PropertyValueListType listOfValues = osConstraint.getListOfValues();
        if (listOfValues == null) {
            return osNames;
        }
        List<ElementValueType> list = listOfValues.getValue();
        for (ElementValueType each : list) {
            String value = each.getValue();
            osNames.add(value);
        }
        return osNames;
    }

    private PackageDescriptorExt getPackageDescriptorExt(DeploymentDescriptorExt deploymentDescriptor, ReferencedPackageType referencedPackage) {
        PackageDescriptorExt packageDescriptor = deploymentDescriptor.getPackageDescriptor();
        String ref = referencedPackage.getContentRef();
        PackageDescriptorExt result = packageDescriptor.packageForContentRef(ref);
        return result;
    }

    public Map<String, String> getResourceMap() {
        return this._resourceMap;
    }

    private String getValue(DisplayTextType displayText) {
        return this.getValue(displayText, null);
    }

    private String getValue(DisplayTextType displayText, String defaultValue) {
        if (displayText == null) {
            return defaultValue;
        }
        return displayText.getValue();
    }

    private List<String> getVersions(VersionConstraintType versionConstraint) {
        ArrayList<String> versions = new ArrayList<String>(5);
        VersionConstraintValueType versionValue = versionConstraint.getSupported();
        List<VersionValueType> list = versionValue.getValue();
        for (VersionValueType each : list) {
            String version = each.getVersion();
            versions.add(version);
        }
        return versions;
    }

    private void initializeDirectory(File file) throws IOException {
        boolean checkCanWrite = false;
        this.initializeDirectory(file, checkCanWrite);
    }

    private void initializeDirectory(File file, boolean checkCanWrite) throws IOException {
        boolean success;
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        boolean isDirectory = file.isDirectory();
        if (isDirectory) {
            if (!checkCanWrite) {
                return;
            }
            this.checkCanWriteToDirectory(file);
        }
        if (success = file.mkdirs()) {
            if (!checkCanWrite) {
                return;
            }
            this.checkCanWriteToDirectory(file);
        }
        this.signalLocationIsUnwriteable(file);
    }

    public void initializeDirectoryLayout(File dpDir) throws IOException {
        this.initializeDirectory(dpDir, true);
        File pdDir = new File(dpDir, "products/descriptors");
        this.initializeDirectory(pdDir);
        File pcDir = new File(dpDir, "products/artifacts");
        this.initializeDirectory(pcDir);
        File repositoryDir = new File(pcDir, "repository");
        File pluginsDir = new File(repositoryDir, "plugins");
        this.initializeDirectory(pluginsDir);
        File featuresDir = new File(repositoryDir, "features");
        this.initializeDirectory(featuresDir);
        File ordersDir = new File(dpDir, "orders");
        this.initializeDirectory(ordersDir);
    }

    public void initializeDirectoryLayout(URI uri) throws IOException {
        File dpDir = new File(uri);
        this.initializeDirectoryLayout(dpDir);
    }

    public IVersion initializedVersionForValue(String value, IOperatingSystem os, IDatastore datastore) {
        Version version = null;
        if (datastore != null) {
            version = datastore.getOSVersion(value);
        }
        if (version == null) {
            version = this._commonModelObjectFactory.createVersion();
            version.setValue(value);
            if (datastore != null) {
                datastore.commit(version);
            }
        }
        return version;
    }

    public void initializeLocalRootPD(PackageDescriptorExt pd, URI localDP) throws IOException, URISyntaxException {
        URI localRootPD = this.mirrorContentForDistributionPoint(pd.getDistributionPointRoot(), pd.getLocation(), localDP);
        PackageDescriptorExt localPD = this.loadPackageDescriptorFromDistributionPoint(pd.getDistributionPointRoot(), localRootPD);
        com.sas.solstice.platform.core.model.ObjectFactory factory = new com.sas.solstice.platform.core.model.ObjectFactory();
        ContentsType contents = pd.getContents();
        List<ContentType> list = contents.getContent();
        list.clear();
        try {
            Marshaller instance = DistributionPointUtility.getMarshaller();
            JAXBElement<PackageDescriptorType> descriptor = factory.createPackageDescriptor(localPD);
            File file = new File(localRootPD);
            instance.marshal(descriptor, file);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComposite loadOrderComposite(URI uri, String orderNumber, IDatastore datastore) throws IOException, URISyntaxException {
        LOGGER.debug("Loading Order " + orderNumber);
        DistributionPointUtility distributionPointUtility = this;
        synchronized (distributionPointUtility) {
            PackageDescriptorExt rootPackageDescriptor = this.getCustomerRootPD(uri);
            ContentExt orderContent = rootPackageDescriptor.getOrderDescriptorContent(orderNumber);
            if (orderContent == null) {
                String message = String.format(ORDER_NUMBER_NOT_FOUND, orderNumber);
                throw new IOException(message);
            }
            PackageDescriptorExt topLevelPD = rootPackageDescriptor.packageForContent(orderContent);
            DeploymentDescriptorExt topLevelDD = topLevelPD.getDeploymentDescriptor();
            return this.evaluateCompositeInstallables(topLevelDD, datastore, null, null, null).get(0);
        }
    }

    public PackageDescriptorExt loadPackageDescriptorFromDistributionPoint(URI distributionPointBase, URI location) throws IOException {
        if (location == null) {
            throw new IllegalArgumentException(MISSING_LOCATION);
        }
        try {
            Unmarshaller instance = DistributionPointUtility.getUnmarshaller();
            URL url = location.toURL();
            JAXBElement element = (JAXBElement)instance.unmarshal(url);
            PackageDescriptorExt descriptor = (PackageDescriptorExt)element.getValue();
            descriptor.setLocation(location);
            descriptor.resolvePackageProperties(distributionPointBase);
            descriptor.setDistributionPointRoot(distributionPointBase);
            return descriptor;
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    public void mergeOrderContentFromPackageDescriptor(ContentExt sourceContent, PackageDescriptorExt pd) throws IOException, JAXBException {
        String purpose = sourceContent.getPurpose();
        boolean valid = "order".equalsIgnoreCase(purpose);
        if (!valid) {
            throw new IllegalArgumentException(CONTENTMANAGER_NOT_ORDER_EXCEPTION);
        }
        String id = sourceContent.getId();
        URI uri = pd.getOrderDescriptorURI(id);
        if (uri != null) {
            return;
        }
        String pathname = sourceContent.getPathname();
        String transformedPathname = this.transformedPathForLocalDP(pathname);
        sourceContent.setPathname(transformedPathname);
        ContentsType contents = pd.getContents();
        List<ContentType> list = contents.getContent();
        list.add(sourceContent);
        URI location = pd.getLocation();
        File file = new File(location);
        com.sas.solstice.platform.core.model.ObjectFactory factory = new com.sas.solstice.platform.core.model.ObjectFactory();
        JAXBElement<PackageDescriptorType> packageDescriptor = factory.createPackageDescriptor(pd);
        Marshaller instance = DistributionPointUtility.getMarshaller();
        instance.marshal(packageDescriptor, file);
    }

    public URI mirrorContentForDistributionPoint(URI sourceRoot, URI sourceBranch, URI destination) throws URISyntaxException, IOException {
        URI relativeURI = sourceBranch;
        URI absoluteURI = sourceBranch;
        if (sourceBranch.isAbsolute()) {
            relativeURI = sourceRoot.relativize(sourceBranch);
        } else {
            absoluteURI = sourceRoot.resolve(sourceBranch);
        }
        URI destinationURI = null;
        destinationURI = sourceRoot.equals(this._masterDP) ? destination.resolve(this.transformedPathForLocalDP(relativeURI)) : destination.resolve(relativeURI);
        URL refURL = absoluteURI.toURL();
        URLConnection connection = NetworkUtilities.getConnectionForURL(refURL);
        long artifactLength = connection.getContentLength();
        if (artifactLength < 0L) {
            File artifactFile = new File(absoluteURI);
            artifactLength = artifactFile.length();
        }
        InputStream inputStream = NetworkUtilities.getStreamForConnection(connection);
        FileUtilities.copy(inputStream, destinationURI, artifactLength);
        return destinationURI;
    }

    private void processRequirements(List<AlternativeRequirementType> requirements, IComposite composite, IDatastore datastore, IFeature parent) {
        for (AlternativeRequirementType requirement : requirements) {
            List<Object> constraints = requirement.getResourceConstraintOrDependencyOrAny();
            for (Object each : constraints) {
                JAXBElement element = (JAXBElement)each;
                Object value = element.getValue();
                if (!(value instanceof RequirementResourceConstraintType)) continue;
                RequirementResourceConstraintType constraint = (RequirementResourceConstraintType)value;
                this.processRequirements(constraint, composite, datastore, parent);
            }
        }
    }

    private void processRequirements(RequirementResourceConstraintType constraint, IComposite composite, IDatastore datastore, IFeature parent) {
        Object object = constraint.getResourceRef();
        ResourceType resourceRef = (ResourceType)object;
        QName qname = resourceRef.getType();
        String name = qname.getLocalPart();
        boolean match = name.equals("OperatingSystem");
        if (!match) {
            return;
        }
        List<String> operatingSystemNames = null;
        List<String> versions = null;
        IVersion minimumVersion = null;
        IVersion maximumVersion = null;
        List<Object> constraints = constraint.getResourceConstraintGroup();
        for (Object object2 : constraints) {
            JAXBElement element = (JAXBElement)object2;
            Object value = element.getValue();
            if (value instanceof PropertyConstraintType) {
                PropertyConstraintType osConstraint = (PropertyConstraintType)value;
                operatingSystemNames = this.getOperatingSystemNames(osConstraint);
                continue;
            }
            if (value instanceof VersionConstraintType) {
                VersionConstraintType versionConstraint = (VersionConstraintType)value;
                versions = this.getVersions(versionConstraint);
                VersionConstraintValueType versionValue = versionConstraint.getSupported();
                List<VersionRangeType> listOfVersionRanges = versionValue.getRange();
                minimumVersion = this.getMinimumVersion(listOfVersionRanges);
                maximumVersion = this.getMaximumVersion(listOfVersionRanges);
                continue;
            }
            this.signalUnhandledObjectType(value);
        }
        if (operatingSystemNames == null) {
            return;
        }
        for (String string : operatingSystemNames) {
            IOperatingSystem os = this.getOperatingSystem(datastore, string);
            if (maximumVersion != null) {
                os.setMaxVersion(maximumVersion);
            }
            if (minimumVersion != null) {
                os.setMinVersion(minimumVersion);
            }
            this.processVersionRequirements(os, versions, datastore);
            if (parent == null) {
                composite.getOperatingSystems().add(os);
                continue;
            }
            parent.getOperatingSystems().add(os);
        }
    }

    public void processRequirements(RequirementsType requirementsType, IComposite composite, IDatastore datastore, IFeature parent) {
        if (requirementsType == null) {
            return;
        }
        List<RequirementType> list = requirementsType.getRequirement();
        for (RequirementType each : list) {
            List<AlternativeRequirementType> alternatives = each.getAlternative();
            this.processRequirements(alternatives, composite, datastore, parent);
        }
    }

    private void processVersionRequirements(IOperatingSystem os, List<String> versions, IDatastore datastore) {
        if (versions == null) {
            return;
        }
        IVersion version = null;
        for (String each : versions) {
            version = this.initializedVersionForValue(each, os, datastore);
            os.getVersions().add(version);
        }
    }

    private String removeDirectory(String path) {
        int index = path.indexOf(47);
        if (index == -1) {
            return path;
        }
        return path.substring(index + 1);
    }

    private void signalLocationIsUnwriteable(File file) throws IOException {
        String path = file.getAbsolutePath();
        String message = MessageFormat.format(LOCATION_UNWRITEABLE, path);
        throw new IOException(message);
    }

    private void signalUnhandledObjectType(Object object) {
    }

    public void synchronizeMirrorMetadataForPackageDescriptor(PackageDescriptorExt pd, URI mirror) throws URISyntaxException, IOException {
        if (pd == null) {
            throw new IllegalArgumentException("pd must not be null");
        }
        if (mirror == null) {
            throw new IllegalArgumentException("mirror must not be null");
        }
        ContentsType contents = pd.getContents();
        List<ContentType> list = contents.getContent();
        for (ContentType each : list) {
            this.synchronizeMirrorMetadataForPackageDescriptor(pd, mirror, each);
        }
    }

    private void synchronizeMirrorMetadataForPackageDescriptor(PackageDescriptorExt packageDescriptor, URI mirror, ContentType content) throws URISyntaxException, IOException {
        String purpose = content.getPurpose();
        boolean match = PackageDescriptorExt.PURPOSE_DESCRIPTION_CONTENT.equalsIgnoreCase(purpose);
        if (match) {
            return;
        }
        URI root = packageDescriptor.getDistributionPointRoot();
        String pathname = content.getPathname();
        URI uri = new URI(pathname);
        this.mirrorContentForDistributionPoint(root, uri, mirror);
    }

    public String transformedPathForLocalDP(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        String value = path;
        boolean customers = value.startsWith("customers");
        if (customers) {
            value = this.removeDirectory(value);
            value = this.removeDirectory(value);
        }
        return value;
    }

    public URI transformedPathForLocalDP(URI uri) throws URISyntaxException {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        String value = uri.toString();
        String local = this.transformedPathForLocalDP(value);
        return new URI(local);
    }
}

