/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.common.utilities;

import com.sas.deployment.common.model.Blueprint;
import com.sas.deployment.common.model.ObjectFactory;
import com.sas.deployment.common.model.generated.IBlueprint;
import com.sas.deployment.common.utilities.DistributionPointUtility;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public final class BlueprintUtilities {
    private static final String OBJECT_FACTORY_PROPERTY = "com.sun.xml.internal.bind.ObjectFactory";
    private static Marshaller marshaller = null;
    private static Unmarshaller unmarshaller = null;

    private static Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext context = BlueprintUtilities.createJAXBContext();
        Unmarshaller instance = context.createUnmarshaller();
        Object value = BlueprintUtilities.createObjectFactoryPropertyValue();
        instance.setProperty(OBJECT_FACTORY_PROPERTY, value);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Unmarshaller getUnmarshaller() throws JAXBException {
        Class<BlueprintUtilities> clazz = BlueprintUtilities.class;
        synchronized (BlueprintUtilities.class) {
            if (unmarshaller == null) {
                unmarshaller = BlueprintUtilities.createUnmarshaller();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return unmarshaller;
        }
    }

    private static Object createObjectFactoryPropertyValue() {
        return new Object[]{new ObjectFactory()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Marshaller getMarshaller() throws JAXBException {
        Class<DistributionPointUtility> clazz = DistributionPointUtility.class;
        synchronized (DistributionPointUtility.class) {
            if (marshaller == null) {
                marshaller = BlueprintUtilities.createMarshaller();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return marshaller;
        }
    }

    private static Marshaller createMarshaller() throws JAXBException {
        JAXBContext context = BlueprintUtilities.createJAXBContext();
        Marshaller instance = context.createMarshaller();
        instance.setProperty("jaxb.formatted.output", (Object)true);
        return instance;
    }

    private static JAXBContext createJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{Blueprint.class});
    }

    public static void createBlueprintFile(IBlueprint blueprint, File blueprintFile) throws JAXBException {
        BlueprintUtilities.getMarshaller().marshal((Object)blueprint, blueprintFile);
    }

    public static IBlueprint getBlueprintFromURIString(String blueprintLocation) throws JAXBException, MalformedURLException, URISyntaxException {
        URI blueprintURI = new URI(blueprintLocation);
        URL blueprintURL = blueprintURI.toURL();
        IBlueprint blueprint = (IBlueprint)BlueprintUtilities.getUnmarshaller().unmarshal(blueprintURL);
        return blueprint;
    }
}

