/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.common.core;

import java.util.logging.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JmxLogConfigurator {
    private static final Logger LOGGER = LogManager.getLogger(JmxLogConfigurator.class);

    public static void configure() {
        JmxLogConfigurator.setLoggerLevel("javax.management.remote.misc", Level.SEVERE);
        JmxLogConfigurator.setLoggerLevel("javax.management.remote.generic", Level.SEVERE);
    }

    private static Level getLevel(java.util.logging.Logger logger) {
        if (logger == null) {
            return null;
        }
        Level level = logger.getLevel();
        if (level != null) {
            return level;
        }
        java.util.logging.Logger parent = logger.getParent();
        return JmxLogConfigurator.getLevel(parent);
    }

    private static void logInformation(String message) {
        String information = JmxLogConfigurator.toFormattedMessage(message);
        LOGGER.info(information);
    }

    private static void logLoggerCouldNotBeFound(String name) {
        String message = String.format("The logger \"%s\" could not be found.", name);
        JmxLogConfigurator.logWarning(message);
    }

    private static void logLoggerLevelChanged(String name, Level oldLevel, Level level) {
        String message = String.format("The logger \"%s\" has had its level changed from \"%s\" to \"%s\".", name, oldLevel, level);
        JmxLogConfigurator.logInformation(message);
    }

    private static void logWarning(String message) {
        String warning = JmxLogConfigurator.toFormattedMessage(message);
        LOGGER.warn(warning);
    }

    private static void setLoggerLevel(String name, Level level) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(name);
        if (logger == null) {
            JmxLogConfigurator.logLoggerCouldNotBeFound(name);
            return;
        }
        Level oldLevel = JmxLogConfigurator.getLevel(logger);
        boolean match = level.equals(oldLevel);
        if (match) {
            return;
        }
        logger.setLevel(level);
        JmxLogConfigurator.logLoggerLevelChanged(name, oldLevel, level);
    }

    private static String toFormattedMessage(String message) {
        String clazz = JmxLogConfigurator.class.getSimpleName();
        String formattedMessage = String.format("%s: %s", clazz, message);
        return formattedMessage;
    }

    private JmxLogConfigurator() {
    }
}

