/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.application.menus.security.internal;

import com.sas.solstice.platform.application.common.api.menu.IMenu;
import com.sas.solstice.platform.application.common.api.menu.IMenuRegistrar;
import com.sas.solstice.platform.application.common.menu.ConsoleMenu;
import java.util.ArrayList;
import java.util.List;

public class Component {
    private static final String CONTEXT_HINT = "com.sas.deployment.application.menus.security: Config, RCLI";
    private IMenuRegistrar registrar;
    private List<IMenu> menus;

    public void activate() {
        List<IMenu> menus = this.build();
        this.setMenus(menus);
        this.register();
    }

    private List<IMenu> build() {
        ArrayList<IMenu> menus = new ArrayList<IMenu>(10);
        String parentId = "configure";
        this.buildConfigureSecurityMenu(parentId, menus);
        ConsoleMenu menu = new ConsoleMenu("setPort", "Set Port");
        menu.setParentId(parentId);
        menu.setPositionHint(2);
        menu.setData(CONTEXT_HINT);
        menus.add(menu);
        return menus;
    }

    private void buildConfigureSecurityMenu(String parentId, List<IMenu> menus) {
        String configureSecurityId = "configureSecurity";
        ConsoleMenu menu = new ConsoleMenu(configureSecurityId, "Configure Security");
        menu.setParentId(parentId);
        menu.setData(CONTEXT_HINT);
        menus.add(menu);
        menu = new ConsoleMenu("enableSecurity", "Enable Security");
        menu.setParentId(configureSecurityId);
        menu.setData(CONTEXT_HINT);
        menus.add(menu);
        menu = new ConsoleMenu("setKeystore", "Set Keystore");
        menu.setParentId(configureSecurityId);
        menu.setData(CONTEXT_HINT);
        menus.add(menu);
        menu = new ConsoleMenu("setKeystorePassword", "Set Keystore Password");
        menu.setParentId(configureSecurityId);
        menu.setData(CONTEXT_HINT);
        menus.add(menu);
        menu = new ConsoleMenu("setTruststore", "Set Truststore");
        menu.setParentId(configureSecurityId);
        menu.setData(CONTEXT_HINT);
        menus.add(menu);
        menu = new ConsoleMenu("setTruststorePassword", "Set Truststore Password");
        menu.setParentId(configureSecurityId);
        menu.setData(CONTEXT_HINT);
        menus.add(menu);
        menu = new ConsoleMenu("useClientAuth", "Use Client Authentication");
        menu.setParentId(configureSecurityId);
        menu.setData(CONTEXT_HINT);
        menus.add(menu);
    }

    public void deactivate() {
        this.unregister();
        this.destroy();
    }

    private void destroy() {
        this.setMenus(null);
    }

    private List<IMenu> getMenus() {
        return this.menus;
    }

    private IMenuRegistrar getRegistrar() {
        return this.registrar;
    }

    private void register() {
        List<IMenu> menus = this.getMenus();
        for (IMenu menu : menus) {
            this.register(menu);
        }
    }

    private void register(IMenu menu) {
        IMenuRegistrar registrar = this.getRegistrar();
        registrar.register(menu);
    }

    private void setMenus(List<IMenu> menus) {
        this.menus = menus;
    }

    public void setRegistrar(IMenuRegistrar registrar) {
        this.registrar = registrar;
    }

    private void unregister() {
        List<IMenu> menus = this.getMenus();
        for (IMenu menu : menus) {
            this.unregister(menu);
        }
    }

    private void unregister(IMenu menu) {
        IMenuRegistrar registrar = this.getRegistrar();
        registrar.unregister(menu);
    }
}

