/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.application.menus.internal;

import com.sas.solstice.platform.application.common.api.menu.IMenu;
import com.sas.solstice.platform.application.common.api.menu.IMenuRegistrar;
import com.sas.solstice.platform.application.common.menu.ConsoleMenu;
import java.util.ArrayList;
import java.util.List;

public class Component {
    private static final String CONTEXT_HINT = "com.sas.deployment.application.menus: Config, CLI, RCLI";
    private IMenuRegistrar registrar;
    private List<IMenu> menus;

    public void activate() {
        List<IMenu> menus = this.build();
        this.setMenus(menus);
        this.register();
    }

    private List<IMenu> build() {
        ArrayList<IMenu> menus = new ArrayList<IMenu>(5);
        String configureId = this.buildConfigureMenu(menus);
        this.buildAdvancedMenu(configureId, menus);
        this.buildHelpMenu(menus);
        return menus;
    }

    private void buildAdvancedMenu(String parentId, List<IMenu> menus) {
        String advancedId = "advanced";
        ConsoleMenu menu = new ConsoleMenu(advancedId, "Advanced");
        menu.setParentId(parentId);
        menu.setPositionHint(Integer.MAX_VALUE);
        menu.setData(CONTEXT_HINT);
        menus.add(menu);
        menu = new ConsoleMenu("setLogsLocation", "Set Logs Location");
        menu.setParentId(advancedId);
        menu.setData(CONTEXT_HINT);
        menus.add(menu);
    }

    private String buildConfigureMenu(List<IMenu> menus) {
        String configureId = "configure";
        ConsoleMenu menu = new ConsoleMenu(configureId, "Configure");
        menu.setData(CONTEXT_HINT);
        menus.add(menu);
        menu = new ConsoleMenu("setJre", "Set Java Runtime");
        menu.setParentId(configureId);
        menu.setPositionHint(1);
        menu.setData(CONTEXT_HINT);
        menus.add(menu);
        return configureId;
    }

    private void buildHelpMenu(List<IMenu> menus) {
        String helpId = "help";
        ConsoleMenu menu = new ConsoleMenu(helpId, "Help");
        menu.setPositionHint(Integer.MAX_VALUE);
        menu.setData(CONTEXT_HINT);
        menus.add(menu);
        menu = new ConsoleMenu("usage", "Usage");
        menu.setParentId(helpId);
        menu.setData(CONTEXT_HINT);
        menus.add(menu);
        menu = new ConsoleMenu("about", "About");
        menu.setParentId(helpId);
        menu.setPositionHint(1);
        menu.setData(CONTEXT_HINT);
        menus.add(menu);
    }

    public void deactivate() {
        this.unregister();
        this.destroy();
    }

    private void destroy() {
        this.setMenus(null);
    }

    private List<IMenu> getMenus() {
        return this.menus;
    }

    private IMenuRegistrar getRegistrar() {
        return this.registrar;
    }

    private void register() {
        List<IMenu> menus = this.getMenus();
        for (IMenu menu : menus) {
            this.register(menu);
        }
    }

    private void register(IMenu menu) {
        IMenuRegistrar registrar = this.getRegistrar();
        registrar.register(menu);
    }

    private void setMenus(List<IMenu> menus) {
        this.menus = menus;
    }

    public void setRegistrar(IMenuRegistrar registrar) {
        this.registrar = registrar;
    }

    private void unregister() {
        List<IMenu> menus = this.getMenus();
        for (IMenu menu : menus) {
            this.unregister(menu);
        }
    }

    private void unregister(IMenu menu) {
        IMenuRegistrar registrar = this.getRegistrar();
        registrar.unregister(menu);
    }
}

