/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.application.commands.security.internal;

import com.sas.deployment.application.commands.AbstractPropertyEditorCommand;
import com.sas.deployment.property.editor.IPropertyEditor;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.command.parameter.Parameter;
import com.sas.solstice.platform.application.common.command.validator.BooleanParameterValidator;
import java.util.Map;

class UseClientAuthCommand
extends AbstractPropertyEditorCommand<IApplicationModel> {
    private static final String ENABLED_ID = "solstice.security.client.auth";

    UseClientAuthCommand(IPropertyEditor propertyEditor) {
        super(propertyEditor);
    }

    @Override
    protected void buildParameterSpecification(IParameterSpecification specification) {
        specification.add(this.createClientAuthEnabledParameter());
    }

    private IParameterSpecification.IParameter createClientAuthEnabledParameter() {
        Parameter parameter = new Parameter(ENABLED_ID, "Enable Client Authentication");
        String value = this.getEnabled();
        parameter.setDefaultValue(value);
        parameter.setValidator(new BooleanParameterValidator());
        parameter.setUsage("True to enable client authentication, or false to disable client authentication.");
        return parameter;
    }

    @Override
    public int execute(IApplicationModel model, Map<String, String> parameters) {
        String value = parameters.get(ENABLED_ID);
        this.setEnabled(value);
        String message = String.format("Client authentication has been set to \"%s\".", value);
        model.println(message);
        return 0;
    }

    @Override
    public String getDecoration() {
        return this.getEnabled();
    }

    private String getEnabled() {
        return this.getProperty(ENABLED_ID);
    }

    private void setEnabled(String enabled) {
        this.setProperty(ENABLED_ID, enabled);
    }
}

