/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.application.commands.security.internal;

import com.sas.deployment.application.commands.AbstractPropertyEditorCommand;
import com.sas.deployment.property.editor.IPropertyEditor;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.command.parameter.Parameter;
import com.sas.solstice.platform.application.common.command.validator.BooleanParameterValidator;
import java.util.Map;

class EnableSecurityCommand
extends AbstractPropertyEditorCommand<IApplicationModel> {
    private static final String ENABLED_ID = "solstice.security.enabled";
    private static final String ENABLED_NAME = "Enable Security";

    EnableSecurityCommand(IPropertyEditor propertyEditor) {
        super(propertyEditor);
    }

    @Override
    protected void buildParameterSpecification(IParameterSpecification specification) {
        specification.add(this.createSecurityEnabledParameter());
    }

    private IParameterSpecification.IParameter createSecurityEnabledParameter() {
        Parameter parameter = new Parameter(ENABLED_ID, ENABLED_NAME);
        String value = this.getEnabled();
        parameter.setDefaultValue(value);
        parameter.setValidator(new BooleanParameterValidator());
        parameter.setUsage("True to enable security, or false to disable security.");
        return parameter;
    }

    @Override
    public int execute(IApplicationModel model, Map<String, String> parameters) {
        String value = parameters.get(ENABLED_ID);
        this.setEnabled(value);
        String message = String.format("Security enablement has been set to \"%s\".", value);
        model.println(message);
        return 0;
    }

    @Override
    public String getDecoration() {
        return this.getEnabled();
    }

    private String getEnabled() {
        return this.getProperty(ENABLED_ID);
    }

    private void setEnabled(String enabled) {
        this.setProperty(ENABLED_ID, enabled);
    }
}

