/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.application.commands.security.internal;

import com.sas.deployment.application.commands.AbstractPropertyEditorCommand;
import com.sas.deployment.application.commands.security.internal.EnableSecurityCommand;
import com.sas.deployment.application.commands.security.internal.SetKeystoreCommand;
import com.sas.deployment.application.commands.security.internal.SetKeystorePasswordCommand;
import com.sas.deployment.application.commands.security.internal.SetPortCommand;
import com.sas.deployment.application.commands.security.internal.SetTruststoreCommand;
import com.sas.deployment.application.commands.security.internal.SetTruststorePasswordCommand;
import com.sas.deployment.application.commands.security.internal.UseClientAuthCommand;
import com.sas.deployment.property.editor.IPropertyEditor;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.command.ICommand;
import com.sas.solstice.platform.application.common.api.command.ICommandRegistrar;
import java.util.ArrayList;
import java.util.List;

public class Component {
    private IPropertyEditor propertyEditor;
    private ICommandRegistrar commandRegistrar;
    private List<ICommand<IApplicationModel>> commands;

    public void activate() {
        List<ICommand<IApplicationModel>> commands = this.build();
        this.setCommands(commands);
        this.register();
    }

    private List<ICommand<IApplicationModel>> build() {
        ArrayList<ICommand<IApplicationModel>> commands = new ArrayList<ICommand<IApplicationModel>>(10);
        IPropertyEditor propertyEditor = this.getPropertyEditor();
        AbstractPropertyEditorCommand command = new EnableSecurityCommand(propertyEditor);
        commands.add(command);
        command = new UseClientAuthCommand(propertyEditor);
        commands.add(command);
        command = new SetKeystoreCommand(propertyEditor);
        commands.add(command);
        command = new SetKeystorePasswordCommand(propertyEditor);
        commands.add(command);
        command = new SetTruststoreCommand(propertyEditor);
        commands.add(command);
        command = new SetTruststorePasswordCommand(propertyEditor);
        commands.add(command);
        command = new SetPortCommand(propertyEditor);
        commands.add(command);
        return commands;
    }

    public void deactivate() {
        this.unregister();
        this.destroy();
    }

    private void destroy() {
        this.setCommands(null);
    }

    private ICommandRegistrar getCommandRegistrar() {
        return this.commandRegistrar;
    }

    private List<ICommand<IApplicationModel>> getCommands() {
        return this.commands;
    }

    private IPropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    private void register() {
        List<ICommand<IApplicationModel>> commands = this.getCommands();
        for (ICommand<IApplicationModel> command : commands) {
            this.register(command);
        }
    }

    private void register(ICommand<IApplicationModel> command) {
        ICommandRegistrar registrar = this.getCommandRegistrar();
        registrar.register(command);
    }

    public void setCommandRegistrar(ICommandRegistrar commandRegistrar) {
        this.commandRegistrar = commandRegistrar;
    }

    private void setCommands(List<ICommand<IApplicationModel>> commands) {
        this.commands = commands;
    }

    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    private void unregister() {
        List<ICommand<IApplicationModel>> commands = this.getCommands();
        for (ICommand<IApplicationModel> command : commands) {
            this.unregister(command);
        }
    }

    private void unregister(ICommand<IApplicationModel> command) {
        ICommandRegistrar registrar = this.getCommandRegistrar();
        registrar.unregister(command);
    }
}

