/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.application.commands.internal;

import com.sas.deployment.property.editor.IPropertyEditor;
import com.sas.deployment.servicewrapper.editor.IServiceWrapperEditor;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.api.command.IParameterSpecification;
import com.sas.solstice.platform.application.common.command.AbstractCommand;
import com.sas.solstice.platform.application.common.command.parameter.Parameter;
import com.sas.solstice.platform.application.common.command.validator.FolderParameterValidator;
import java.util.Map;

class SetLogsLocationCommand
extends AbstractCommand<IApplicationModel> {
    private static final String PATH_ID = "solstice.log.location";
    private static final String SERVICE_WRAPPER_PATH_ID = "wrapper.logfile";
    private IPropertyEditor propertyEditor;
    private IServiceWrapperEditor serviceWrapperEditor;

    SetLogsLocationCommand(IPropertyEditor propertyEditor, IServiceWrapperEditor serviceWrapperEditor) {
        this.setPropertyEditor(propertyEditor);
        this.setServiceWrapperEditor(serviceWrapperEditor);
    }

    @Override
    protected void buildParameterSpecification(IParameterSpecification specification) {
        specification.add(this.createLogsLocationParameter());
    }

    private IParameterSpecification.IParameter createLogsLocationParameter() {
        Parameter parameter = new Parameter(PATH_ID, "Logs Location");
        String value = this.getLogsLocation();
        parameter.setDefaultValue(value);
        parameter.setValidator(new FolderParameterValidator());
        parameter.setUsage("The fully-qualified folder path to the logs location.");
        return parameter;
    }

    @Override
    public int execute(IApplicationModel model, Map<String, String> parameters) {
        String value = parameters.get(PATH_ID);
        this.setLogsLocation(value);
        String message = String.format("The logs location has been set to \"%s\".", value);
        model.println(message);
        return 0;
    }

    @Override
    public String getDecoration() {
        return this.getLogsLocation();
    }

    private String getLogsLocation() {
        IPropertyEditor editor = this.getPropertyEditor();
        return editor.getProperty(PATH_ID);
    }

    private IPropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    private IServiceWrapperEditor getServiceWrapperEditor() {
        return this.serviceWrapperEditor;
    }

    private String normalize(String value) {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            return value;
        }
        if (osName.startsWith("Win")) {
            return value.replace('\\', '/');
        }
        return value;
    }

    private void setLogsLocation(String path) {
        IPropertyEditor propertyEditor = this.getPropertyEditor();
        propertyEditor.setProperty(PATH_ID, path);
        String serviceWrapperPath = this.normalize(path);
        serviceWrapperPath = String.format("%s/wrapper.log", serviceWrapperPath);
        IServiceWrapperEditor serviceWrapperEditor = this.getServiceWrapperEditor();
        serviceWrapperEditor.setProperty(SERVICE_WRAPPER_PATH_ID, serviceWrapperPath);
    }

    private void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    private void setServiceWrapperEditor(IServiceWrapperEditor serviceWrapperEditor) {
        this.serviceWrapperEditor = serviceWrapperEditor;
    }
}

