/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.application.commands;

import com.sas.deployment.property.editor.IPropertyEditor;
import com.sas.solstice.platform.application.common.api.IApplicationModel;
import com.sas.solstice.platform.application.common.command.AbstractCommand;

public abstract class AbstractPropertyEditorCommand<T extends IApplicationModel>
extends AbstractCommand<T> {
    private IPropertyEditor propertyEditor;

    protected AbstractPropertyEditorCommand(IPropertyEditor propertyEditor) {
        if (propertyEditor == null) {
            throw new IllegalArgumentException("propertyEditor must not be null");
        }
        this.setPropertyEditor(propertyEditor);
    }

    protected final String getProperty(String key) {
        return this.getProperty(key, null);
    }

    protected final String getProperty(String key, String defaultValue) {
        IPropertyEditor editor = this.getPropertyEditor();
        String value = editor.getProperty(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private IPropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    protected final void setProperty(String key, String value) {
        IPropertyEditor editor = this.getPropertyEditor();
        editor.setProperty(key, value);
    }

    private void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }
}

