/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.agent.jmx.server;

import com.sas.deployment.common.control.AgentMBean;
import com.sas.deployment.common.control.OperationEventBroadcasterMBean;
import com.sas.deployment.common.core.JmxLogConfigurator;
import com.sas.deployment.common.utilities.SecurityConfig;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXConnectorServerMBean;
import javax.management.remote.JMXServiceURL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Server
implements NotificationListener {
    private static Logger logger;
    private MBeanServer _mbeanServer;
    private JMXConnectorServerMBean _connectorServer;
    private AgentMBean _implementation;
    private OperationEventBroadcasterMBean _eventBroadcaster;
    private SecurityConfig _securityConfig;

    public Server() {
        this(null);
    }

    public Server(Properties securityProperties) {
        try {
            this.setSecurityConfig(this.createSecurityConfig(securityProperties));
        }
        catch (IllegalArgumentException iaEx) {
            logger.fatal("Agent terminating due to fatal error during startup.");
            System.exit(42);
        }
    }

    private void addProtocolProviderPackagesPropertyTo(Map<String, Object> environment) {
        String key = this.getProtocolProviderPackagesPropertyKey();
        String value = this.getProtocolProviderPackagesPropertyValue();
        environment.put(key, value);
    }

    private void addSecurityPropertiesTo(Map<String, Object> environment) {
        SecurityConfig config = this.getSecurityConfig();
        config.addSecurityToServerEnvironment(environment);
    }

    private JMXConnectorServerMBean createConnectorServer() throws IOException {
        Map<String, Object> environment = this.createEnvironment();
        JMXServiceURL url = this.createServiceUrl();
        MBeanServer mbeanServer = this.getMBeanServer();
        return JMXConnectorServerFactory.newJMXConnectorServer(url, environment, mbeanServer);
    }

    private Map<String, Object> createEnvironment() {
        HashMap<String, Object> environment = new HashMap<String, Object>(7);
        this.addProtocolProviderPackagesPropertyTo(environment);
        this.addSecurityPropertiesTo(environment);
        return environment;
    }

    private Object createMBean() throws NotCompliantMBeanException {
        AgentMBean implementation = this.getImplementation();
        Class<AgentMBean> clazz = this.getMBeanClass();
        return new StandardMBean(implementation, clazz);
    }

    private ObjectName createObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException exception) {
            return null;
        }
    }

    private SecurityConfig createSecurityConfig(Properties securityProperties) {
        Properties properties = this.toValidProperties(securityProperties);
        SecurityConfig instance = new SecurityConfig(properties, true);
        instance.setTlsProperties();
        return instance;
    }

    private JMXServiceURL createServiceUrl() throws MalformedURLException {
        String url = this.createUrl();
        return new JMXServiceURL(url);
    }

    private String createUrl() {
        String port = this.getPort();
        return "service:jmx:jmxmp://".concat("localhost:").concat(port);
    }

    private MBeanServer findMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    private JMXConnectorServerMBean getConnectorServer() {
        return this._connectorServer;
    }

    public OperationEventBroadcasterMBean getEventBroadcaster() {
        return this._eventBroadcaster;
    }

    private AgentMBean getImplementation() {
        return this._implementation;
    }

    private Class<AgentMBean> getMBeanClass() {
        return AgentMBean.class;
    }

    private String getMBeanName() {
        return "com.sas.solstice:TYPE=Agent";
    }

    private MBeanServer getMBeanServer() {
        return this._mbeanServer;
    }

    private String getPort() {
        String key = this.getPortPropertyKey();
        String defaultValue = this.getPortDefaultProperty();
        return System.getProperty(key, defaultValue);
    }

    private String getPortDefaultProperty() {
        return "5660";
    }

    private String getPortPropertyKey() {
        return "solstice.agent.jmx.port";
    }

    private String getProtocolProviderPackagesPropertyKey() {
        return "jmx.remote.protocol.provider.pkgs";
    }

    private String getProtocolProviderPackagesPropertyValue() {
        return "com.sun.jmx.remote.protocol";
    }

    private SecurityConfig getSecurityConfig() {
        return this._securityConfig;
    }

    @Override
    public void handleNotification(Notification notif, Object handback) {
        if (notif instanceof JMXConnectionNotification) {
            JMXConnectionNotification conNotif = (JMXConnectionNotification)notif;
            if (conNotif.getType().equals("jmx.remote.connection.closed")) {
                logger.debug(String.format("JMX connection closed for %s", conNotif.getConnectionId()));
            } else if (conNotif.getType().equals("jmx.remote.connection.failed")) {
                logger.warn(String.format("JMX connection failed for %s", conNotif.getConnectionId()));
            } else if (conNotif.getType().equals("jmx.remote.connection.opened")) {
                logger.debug(String.format("New JMX connection opened for %s", conNotif.getConnectionId()));
            } else if (conNotif.getType().equals("jmx.remote.connection.notifs.lost")) {
                logger.warn(String.format("JMX connection for %s may have lost notifications", conNotif.getConnectionId()));
            }
        } else {
            logger.debug(String.format("Notification received: %s", notif.toString()));
        }
    }

    private void registerMBean() throws NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException {
        MBeanServer mbeanServer = this.findMBeanServer();
        Object mbean = this.createMBean();
        ObjectName name = this.createObjectName(this.getMBeanName());
        mbeanServer.registerMBean(mbean, name);
        this.setMBeanServer(mbeanServer);
    }

    private void setConnectorServer(JMXConnectorServerMBean connectorServer) {
        this._connectorServer = connectorServer;
    }

    public void setEventBroadcaster(OperationEventBroadcasterMBean instance) {
        this._eventBroadcaster = instance;
    }

    public void setImplementation(AgentMBean implementation) {
        this._implementation = implementation;
    }

    private void setMBeanServer(MBeanServer mbeanServer) {
        this._mbeanServer = mbeanServer;
    }

    private void setSecurityConfig(SecurityConfig securityConfig) {
        this._securityConfig = securityConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException, IOException {
        Server server = this;
        synchronized (server) {
            this.registerMBean();
            this.startConnectorServer();
        }
    }

    private void startConnectorServer() throws IOException {
        JMXConnectorServerMBean connectorServer = this.createConnectorServer();
        ((JMXConnectorServer)connectorServer).addNotificationListener(this, null, this.getMBeanServer());
        connectorServer.start();
        this.setConnectorServer(connectorServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws MBeanRegistrationException, InstanceNotFoundException, IOException {
        Server server = this;
        synchronized (server) {
            this.stopConnectorServer();
            this.unregisterMBean();
        }
    }

    private void stopConnectorServer() throws IOException {
        JMXConnectorServerMBean connectorServer = this.getConnectorServer();
        if (connectorServer == null) {
            return;
        }
        try {
            connectorServer.stop();
        }
        finally {
            this.setConnectorServer(null);
        }
    }

    private Properties toValidProperties(Properties securityProperties) {
        if (securityProperties != null) {
            return securityProperties;
        }
        return System.getProperties();
    }

    private void unregisterMBean() throws MBeanRegistrationException, InstanceNotFoundException {
        MBeanServer mbeanServer = this.getMBeanServer();
        if (mbeanServer == null) {
            return;
        }
        ObjectName name = this.createObjectName(this.getMBeanName());
        try {
            mbeanServer.unregisterMBean(name);
        }
        finally {
            this.setMBeanServer(null);
        }
    }

    static {
        JmxLogConfigurator.configure();
        logger = LogManager.getLogger(Server.class);
    }
}

