/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.agent.jmx.client.internal;

import com.sas.solstice.platform.core.dao.PlatformMessage;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OperationEventListener
implements NotificationListener {
    private static Logger logger = LogManager.getLogger(OperationEventListener.class);
    private String _currentItem;
    private long _currentPercentDone;
    private long _overallPercentDone;
    private static final char CARRIAGE_RETURN = '\r';
    private static final long ONE_HUNDRED = 100L;
    private static final String PROGRESS_MESSAGE = "%cInstalling %-12s %3d percent complete, overall %3d percent complete";

    String getCurrentItem() {
        return this._currentItem;
    }

    long getCurrentPercentDone() {
        return this._currentPercentDone;
    }

    long getOverallPercentDone() {
        return this._overallPercentDone;
    }

    @Override
    public void handleNotification(Notification notif, Object handBack) {
        logger.debug(String.format("handleNotification: handling notification: %s", notif.getUserData().toString()));
        PlatformMessage message = (PlatformMessage)notif.getUserData();
        String type = notif.getType();
        this.handlePlatformMessage(message, type);
    }

    private void handlePlatformMessage(PlatformMessage message, String type) {
        if (message.isEqualTopic("solstice.provision.progress.increment", type)) {
            String feature = message.getFeature();
            long currentPercent = message.getCurrentPercentDone();
            long overallPercent = message.getOverallPercentDone();
            this.handleProgressIncrement(feature, currentPercent, overallPercent);
        } else if (message.isEqualTopic("solstice.provision.progress.beginning", type)) {
            String feature = message.getFeature();
            this.setCurrentItem(feature);
            long currentPercent = 0L;
            long overallPercent = this.getOverallPercentDone();
            this.handleProgressIncrement(feature, currentPercent, overallPercent);
        } else if (message.isEqualTopic("solstice.provision.progress.complete", type)) {
            String feature = message.getFeature();
            if (this.getCurrentPercentDone() < 100L) {
                this.handleProgressIncrement(feature, 100L, this.getOverallPercentDone());
            }
        } else if (message.isEqualTopic("solstice.provision.beginning", type)) {
            this.println(String.format("Installing %d products", message.getCount()));
        } else if (message.isEqualTopic("solstice.provision.complete", type)) {
            if (this.getOverallPercentDone() < 100L) {
                this.handleProgressIncrement(this.getCurrentItem(), this.getCurrentPercentDone(), 100L);
            }
            this.println("\n\nInstallation completed");
        }
    }

    private void handleProgressIncrement(String currentItem, long currentPercent, long overallPercent) {
        this.setCurrentPercentDone(currentPercent);
        this.setOverallPercentDone(overallPercent);
        String message = String.format(PROGRESS_MESSAGE, Character.valueOf('\r'), currentItem, currentPercent, overallPercent);
        this.print(message);
    }

    private void print(String message) {
        System.out.print(message);
    }

    private void println(String message) {
        System.out.println(message);
    }

    void setCurrentItem(String item) {
        this._currentItem = item;
    }

    void setCurrentPercentDone(long percent) {
        this._currentPercentDone = percent;
    }

    void setOverallPercentDone(long percent) {
        this._overallPercentDone = percent;
    }
}

