/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.agent.jmx.client.internal;

import java.util.IllegalFormatException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class Log {
    private static final String USE_FULL_CLASS_NAME_PROPERTY_KEY = "com.sas.deployment.log.useFullClassName";
    private Object _id;
    private Logger _logger;

    private static void checkId(Object id) {
        if (id != null) {
            return;
        }
        throw new IllegalArgumentException("id must not be null");
    }

    private static Logger createLogger(Class<?> id) {
        Log.checkId(id);
        return LogManager.getLogger(id);
    }

    private static Logger createLogger(Object id) {
        Log.checkId(id);
        Class<?> clazz = id.getClass();
        return Log.createLogger(clazz);
    }

    private static Logger createLogger(String id) {
        Log.checkId(id);
        return LogManager.getLogger((String)id);
    }

    static void debug(Class<?> id, String message, Object ... values) {
        Log log = new Log(id);
        log.debug(message, values);
    }

    static void error(Class<?> id, String message, Object ... values) {
        Log log = new Log(id);
        log.error(message, values);
    }

    static void error(Class<?> id, String message, Throwable throwable, Object ... values) {
        Log log = new Log(id);
        log.error(message, throwable, values);
    }

    static void info(Class<?> id, String message, Object ... values) {
        Log log = new Log(id);
        log.info(message, values);
    }

    static void warn(Class<?> id, String message, Object ... values) {
        Log log = new Log(id);
        log.warn(message, values);
    }

    Log(Class<?> id) {
        this(id, Log.createLogger(id));
    }

    Log(Object id) {
        this(id, Log.createLogger(id));
    }

    private Log(Object id, Logger logger) {
        this.setId(id);
        this.setLogger(logger);
    }

    Log(String id) {
        this(id, Log.createLogger(id));
    }

    private void checkThrowableNotNull(Throwable throwable) {
        if (throwable != null) {
            return;
        }
        throw new IllegalArgumentException("throwable must not be null");
    }

    void debug(String message, Object ... values) {
        Logger logger = this.getLogger();
        String value = this.toFormattedMessage(message, values);
        logger.debug(value);
    }

    void debug(String message, Throwable throwable, Object ... values) {
        this.checkThrowableNotNull(throwable);
        Logger logger = this.getLogger();
        String value = this.toFormattedMessage(message, values);
        logger.debug(value, throwable);
    }

    void error(String message, Object ... values) {
        Logger logger = this.getLogger();
        String value = this.toFormattedMessage(message, values);
        logger.error(value);
    }

    void error(String message, Throwable throwable, Object ... values) {
        this.checkThrowableNotNull(throwable);
        Logger logger = this.getLogger();
        String value = this.toFormattedMessage(message, values);
        logger.error(value, throwable);
    }

    private String getClassName(Class<?> clazz) {
        boolean useFullClassName = Boolean.getBoolean(USE_FULL_CLASS_NAME_PROPERTY_KEY);
        return useFullClassName ? clazz.getName() : clazz.getSimpleName();
    }

    private String getFormattedId() {
        Object id = this.getId();
        if (id instanceof String) {
            return (String)id;
        }
        if (id instanceof Class) {
            Class clazz = (Class)id;
            return this.getClassName(clazz);
        }
        return id.toString();
    }

    private Object getId() {
        return this._id;
    }

    private Logger getLogger() {
        return this._logger;
    }

    void info(String message, Object ... values) {
        Logger logger = this.getLogger();
        String value = this.toFormattedMessage(message, values);
        logger.info(value);
    }

    private void logErrorFailedToFormatMessage(String message, IllegalFormatException exception) {
        Logger logger = Log.createLogger(this);
        String prefix = this.getClassName(Log.class);
        String errorMessage = String.format("%s: Failed to format the message \"%s\", reason is \"%s\"", prefix, message, exception);
        logger.error(errorMessage, (Throwable)exception);
    }

    private void setId(Object id) {
        this._id = id;
    }

    private void setLogger(Logger logger) {
        this._logger = logger;
    }

    private String toFormattedMessage(String template, Object ... values) {
        if (template == null) {
            throw new IllegalArgumentException("template must not be null");
        }
        String message = this.toFormattedMessageTemplate(template);
        if (values.length == 0) {
            return message;
        }
        try {
            return String.format(message, values);
        }
        catch (IllegalFormatException exception) {
            this.logErrorFailedToFormatMessage(message, exception);
            return message;
        }
    }

    private String toFormattedMessageTemplate(String template) {
        String id = this.getFormattedId();
        return String.format("%s: %s", id, template);
    }

    void warn(String message, Object ... values) {
        Logger logger = this.getLogger();
        String value = this.toFormattedMessage(message, values);
        logger.warn(value);
    }
}

