/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deployment.agent.app;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.sas.deployment.common.control.AgentInfo;
import com.sas.deployment.common.control.AgentMBean;
import com.sas.deployment.common.control.IAgentDataComponent;
import com.sas.deployment.common.model.generated.IBlueprint;
import com.sas.deployment.common.model.generated.IBlueprintItem;
import com.sas.deployment.common.model.generated.IComposite;
import com.sas.deployment.common.model.generated.IFeature;
import com.sas.deployment.common.model.generated.ILanguage;
import com.sas.deployment.common.model.generated.IParameterValue;
import com.sas.deployment.common.model.generated.ISASOrder;
import com.sas.deployment.common.utilities.EncodedPassword;
import com.sas.deployment.jni.runas.RunAs;
import com.sas.solstice.platform.api.deployment.IDeployAPI;
import com.sas.solstice.platform.core.dao.Results;
import com.sas.solstice.platform.utilities.FileUtilities;
import com.sas.tools.installs.it.schema.validation.ValidationListType;
import com.sas.tools.installs.it.schema.validation.ValidationType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.Vector;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.LoggerFactory;

public class Agent
implements AgentMBean {
    private static final String AGENT_READY = "Ready...";
    private static final String AGENT_INSTALLING = "Installing...";
    private static final String AGENT_TIMEOUT_PROPERTY_KEY = "deployment.agent.timeout";
    private static final String AGENT_TIMEOUT_PROPERTY_DEFAULT = "180";
    private static final String AGENT_TIMEOUT = Agent.getProperty("deployment.agent.timeout", "180");
    private static final String OS_ARCH_PROPERTY_KEY = "os.arch";
    private static final String X64_BIT_VARIABLE = "64";
    private static final String OS_VERSION_PROPERTY_KEY = "os.version";
    private static final String OS_NAME_PROPERTY_KEY = "os.name";
    private static final String RUN_AS_LIB_NAME = "RunAs";
    private static final String RUN_AS_LIB_64_NAME = "RunAs64";
    private static final String UTF8_CHARSET_NAME = "UTF8";
    private static final String FRONTSLASH = "/";
    private static final String FRONTSLASHES = "//";
    private static final String SPACE = " ";
    private static final String USER_DIR = "user.dir";
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(Agent.class);
    private IAgentDataComponent _agentDataComponent;
    private IDeployAPI _deployAPI;
    private AgentInfo _agentInfo;
    private String _agentStatus = "Ready...";

    private static String getProperty(String key) {
        return System.getProperty(key);
    }

    private static String getProperty(String key, String defaultValue) {
        return System.getProperty(key, defaultValue);
    }

    private int calcuateHashedCollectionSizeEstimate(int capacity) {
        if (capacity <= 0) {
            return 0;
        }
        int size = capacity * 4 / 3 + 1;
        return size;
    }

    private String constructProcMessage(Worker worker) {
        StringBuffer message = new StringBuffer("");
        Integer exit = worker.getExit();
        if (exit == null) {
            return message.toString();
        }
        message.append(String.format("Return code: %s", exit));
        if (exit == 0) {
            return message.toString();
        }
        String value = worker.getErrorMessage();
        message.append(String.format("\nErrorStream: %s", value));
        return message.toString();
    }

    private boolean createDirectory(File dirFile) {
        if (dirFile.isDirectory()) {
            return true;
        }
        return dirFile.mkdirs();
    }

    @Override
    public boolean createDirectory(String dirPath) {
        File dir = new File(dirPath);
        return this.createDirectory(dir);
    }

    private Map<String, Vector<String>> createFeatureIdToLanguageTypeMap(IBlueprint blueprint) {
        List<IBlueprintItem> list = blueprint.getBlueprintItems();
        int count = list.size();
        int size = this.calcuateHashedCollectionSizeEstimate(count);
        HashMap<String, Vector<String>> map = new HashMap<String, Vector<String>>(size);
        for (IBlueprintItem each : list) {
            IFeature feature = each.getFeature();
            String key = feature.getFeatureId();
            Vector<String> value = this.getLanguageTypes(feature);
            map.put(key, value);
        }
        return map;
    }

    private Map<String, String> createParameterNameToParameterValuesMap(IBlueprint blueprint) {
        List<IParameterValue> list = blueprint.getParameterValues();
        int count = list.size();
        int size = this.calcuateHashedCollectionSizeEstimate(count);
        HashMap<String, String> map = new HashMap<String, String>(size);
        for (IParameterValue each : list) {
            String key = each.getName();
            String value = each.getValue();
            map.put(key, value);
        }
        return map;
    }

    @Override
    public URI createURI(String value) {
        URI uri = null;
        IllegalArgumentException iae = null;
        String path = value.replace(FRONTSLASHES, FRONTSLASH);
        if (!this.startsWithWindowsDriveLetter(path)) {
            try {
                uri = URI.create(path);
                if (uri.isAbsolute()) {
                    return uri;
                }
            }
            catch (IllegalArgumentException e) {
                iae = e;
            }
        }
        if (this.isFileUriCompatible(path)) {
            File file = new File(path);
            uri = file.toURI();
            return uri;
        }
        if (iae != null) {
            throw iae;
        }
        String message = String.format("The value \"%s\" could not be made into a URI.", path);
        throw new IllegalArgumentException(message);
    }

    private void debugLogArguments(String[] args) {
        String arguments = this.toString(args);
        String logInfo = String.format("invoking exec with arguments: %s", arguments);
        LOGGER.debug(logInfo);
    }

    @Override
    public Results doExec(String[] args) {
        return this.doExec(args, null, Integer.valueOf(AGENT_TIMEOUT));
    }

    @Override
    public Results doExec(String[] args, int timeOut) {
        return this.doExec(args, null, timeOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Results doExec(String[] args, char[] password, int timeOut) {
        this.debugLogArguments(args);
        Results results = new Results();
        Runtime rt = Runtime.getRuntime();
        Process proc = null;
        OutputStream procOutput = null;
        try {
            proc = rt.exec(args);
            if (password != null) {
                procOutput = proc.getOutputStream();
                byte[] bpassword = new byte[password.length];
                for (int i = 0; i < password.length; ++i) {
                    bpassword[i] = (byte)password[i];
                }
                procOutput.write(bpassword);
                procOutput.write(10);
                procOutput.flush();
                Arrays.fill(password, '\u0000');
                Arrays.fill(bpassword, (byte)0);
                procOutput.write(bpassword);
                procOutput.flush();
            }
            Worker worker = new Worker(proc);
            worker.start();
            try {
                int total = timeOut * 1000;
                Long longTimeOut = total;
                worker.join(longTimeOut);
                Integer exit = worker.getExit();
                int status = 2;
                int substatus = 0;
                String message = "Operation timed out";
                if (exit != null) {
                    status = 0;
                    substatus = exit;
                    if (substatus != 0) {
                        status = 4;
                    }
                    message = this.constructProcMessage(worker);
                }
                results.setStatus(status);
                results.setSubstatus(substatus);
                results.setMessage(message);
                if (procOutput != null) {
                    procOutput.close();
                }
            }
            catch (InterruptedException ex) {
                worker.interrupt();
                Thread.currentThread().interrupt();
                results.setStatus(2);
                results.setMessage("Operation was interrupted");
            }
            finally {
                proc.destroy();
            }
        }
        catch (IOException e) {
            results.setStatus(4);
            results.setMessage(e.getMessage());
            results.setException(e);
        }
        return results;
    }

    @Override
    public Results doExecAsUser(String encryptedUserName, String encryptedPassword, String domain, String[] args) {
        return this.doExecAsUser(encryptedUserName, encryptedPassword, domain, args, Integer.valueOf(AGENT_TIMEOUT));
    }

    @Override
    public Results doExecAsUser(String encryptedUserName, String encryptedPassword, String domain, String[] args, int timeOut) {
        String[] commandArgs;
        String user = new String(EncodedPassword.uncodeEncryptedString(encryptedUserName));
        char[] password = EncodedPassword.uncodeEncryptedString(encryptedPassword);
        Results result = new Results();
        boolean windows = this.isWindows();
        StringBuilder builder = new StringBuilder();
        for (String string : commandArgs = args) {
            if (builder.length() > 0) {
                builder.append(SPACE);
            }
            builder.append(string);
        }
        String commandToRun = builder.toString();
        if (windows) {
            String agentArch = Agent.getProperty(OS_ARCH_PROPERTY_KEY);
            if (agentArch.contains(X64_BIT_VARIABLE)) {
                System.loadLibrary(RUN_AS_LIB_64_NAME);
            } else {
                System.loadLibrary(RUN_AS_LIB_NAME);
            }
            RunAs runAs = new RunAs();
            try {
                String message = runAs.runAs(user, domain, password, commandToRun, timeOut);
                result.setMessage(message);
            }
            catch (Exception e) {
                result.setStatus(4);
                result.setException(e);
            }
        } else {
            String[] cmd = new String[]{"/bin/sh", "-c", "sudo -S -u " + user + " /bin/sh -c \"" + commandToRun + "\""};
            result = this.doExec(cmd, password, timeOut);
        }
        if (password != null) {
            Arrays.fill(password, '\u0000');
        }
        return result;
    }

    public IAgentDataComponent getAgentDataComponent() {
        return this._agentDataComponent;
    }

    @Override
    public AgentInfo getAgentInfo() {
        this._agentInfo.setCanProvision(this.isProvisioningSupported());
        this._agentInfo.populateConfigProperties();
        return this._agentInfo;
    }

    @Override
    public String getAgentStatus() {
        return this._agentStatus;
    }

    public IDeployAPI getDeployAPI() {
        return this._deployAPI;
    }

    private List<String> getFeatureIds(IBlueprint blueprint) {
        List<IBlueprintItem> list = blueprint.getBlueprintItems();
        int size = list.size();
        ArrayList<String> ids = new ArrayList<String>(size);
        for (IBlueprintItem each : list) {
            IFeature feature = each.getFeature();
            String id = feature.getFeatureId();
            ids.add(id);
        }
        return ids;
    }

    private Vector<String> getLanguageTypes(IFeature feature) {
        List<ILanguage> list = feature.getLanguages();
        int size = list.size();
        Vector<String> types = new Vector<String>(size);
        for (ILanguage each : list) {
            String type = each.getType();
            types.add(type);
        }
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMacAddress() {
        String macAddress = "";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream(baos);){
            Object network;
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            byte[] mac = null;
            while (networks.hasMoreElements()) {
                byte[] tempBytes;
                network = networks.nextElement();
                boolean isLoopback = ((NetworkInterface)network).isLoopback();
                if (isLoopback || (tempBytes = ((NetworkInterface)network).getHardwareAddress()) == null) continue;
                mac = tempBytes;
            }
            if (mac == null) {
                LOGGER.info("Address doesn't exist or is not accessible.");
                network = macAddress;
                return network;
            }
            String template = "%02X%s";
            String hyphen = "-";
            String blank = "";
            for (int i = 0; i < mac.length; ++i) {
                byte b = mac[i];
                ps.format(template, b, i < mac.length - 1 ? hyphen : blank);
            }
            macAddress = baos.toString(UTF8_CHARSET_NAME);
        }
        return macAddress;
    }

    private String getOperatingSystemName() {
        String value = Agent.getProperty(OS_NAME_PROPERTY_KEY);
        value = this.toLowercase(value);
        return value;
    }

    @Override
    public String getOsName() {
        return Agent.getProperty(OS_NAME_PROPERTY_KEY);
    }

    @Override
    public String getOsVersion() {
        return Agent.getProperty(OS_VERSION_PROPERTY_KEY);
    }

    @Override
    public Results install(IBlueprint blueprint, String metadataRoot, String artifactRoot, boolean dryRun) {
        Results response = new Results();
        LOGGER.info("AgentControl::install() - beginning installation...");
        this._agentStatus = AGENT_INSTALLING;
        List<String> featureIds = this.getFeatureIds(blueprint);
        Map<String, Vector<String>> featureIdToLanguageTypesMap = this.createFeatureIdToLanguageTypeMap(blueprint);
        Map<String, String> parameterNameToParameterValuesMap = this.createParameterNameToParameterValuesMap(blueprint);
        URI mdrURI = null;
        String mdrLocation = Agent.getProperty("solstice.mdr.location");
        if (mdrLocation != null) {
            File file = new File(mdrLocation, "mdr.xml");
            mdrURI = file.toURI();
        }
        ISASOrder order = blueprint.getOrder();
        IComposite composite = order.getComposite();
        URI uri = null;
        try {
            uri = new URI(composite.getURI());
        }
        catch (URISyntaxException e) {
            response.setMessage(e.getMessage());
            response.setStatus(4);
            return response;
        }
        IDeployAPI api = this.getDeployAPI();
        boolean performInstall = blueprint.isPerformInstall();
        boolean performConfig = blueprint.isPerformConfig();
        response = dryRun ? api.resolve(metadataRoot, uri, featureIds, featureIdToLanguageTypesMap, parameterNameToParameterValuesMap, performInstall, performConfig) : api.resolveAndProvision(metadataRoot, artifactRoot, uri, featureIds, featureIdToLanguageTypesMap, parameterNameToParameterValuesMap, mdrURI, performInstall, performConfig);
        if (response.hasRequestParameters()) {
            return response;
        }
        LOGGER.info("Agent - completed action...");
        this._agentStatus = AGENT_READY;
        return response;
    }

    private boolean isAbsoluteUnixPath(String value) {
        return value.matches("/.*");
    }

    private boolean isAbsoluteWindowsPath(String value) {
        if (this.startsWithWindowsUnc(value)) {
            return true;
        }
        return value.matches("[a-zA-Z]:\\\\.*");
    }

    private boolean isFileUriCompatible(String value) {
        return this.isAbsoluteWindowsPath(value) || this.isAbsoluteUnixPath(value);
    }

    @Override
    public boolean isProvisioningSupported() {
        IDeployAPI api = this.getDeployAPI();
        return api != null;
    }

    private boolean isWindows() {
        String name = this.getOperatingSystemName();
        boolean state = name.contains("win");
        return state;
    }

    private void logAgentInfo() {
        Level saveLevel = LOGGER.getLevel();
        LOGGER.setLevel(Level.INFO);
        this.getAgentDataComponent().logBundleInfo(LOGGER);
        AgentInfo info = this.getAgentInfo();
        info.setCanProvision(null);
        LOGGER.info(info.toString());
        LOGGER.setLevel(saveLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] pullFile(String filePath, long lastBlockIndex) throws IOException {
        File f = new File(filePath);
        if (!f.exists()) {
            return null;
        }
        int bufLen = 20480000;
        byte[] buf = new byte[bufLen];
        try (RandomAccessFile raf = new RandomAccessFile(filePath, "r");){
            if (raf.length() < lastBlockIndex) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            raf.seek(lastBlockIndex);
            int length = raf.read(buf, 0, bufLen);
            if (length == -1) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (length < bufLen) {
                byte[] tmp = new byte[length];
                System.arraycopy(buf, 0, tmp, 0, length);
                byte[] byArray = tmp;
                return byArray;
            }
        }
        return buf;
    }

    @Override
    public int getPosixFilePerms(String filePath) throws Exception {
        return FileUtilities.getPosixFilePermissions(filePath);
    }

    @Override
    public void setPosixFilePerms(String filePath, int perms) throws Exception {
        FileUtilities.setPosixFilePermissions(filePath, perms);
    }

    @Override
    public List<String> pullFolderList(String folderPath, boolean recursive, List<String> extensionsToIgnore) {
        ArrayList<String> fileList = new ArrayList<String>();
        File folder = new File(folderPath);
        if (!folder.exists()) {
            return null;
        }
        if (folder.isFile()) {
            fileList.add(folderPath);
            return fileList;
        }
        String pathToAdd = folderPath + FRONTSLASH;
        fileList.add(pathToAdd);
        for (File f : folder.listFiles()) {
            if (f.isDirectory()) {
                if (!recursive) continue;
                fileList.addAll(this.pullFolderList(f.getAbsolutePath(), recursive, extensionsToIgnore));
                continue;
            }
            if (extensionsToIgnore != null && this.ignoreFile(f.getName(), extensionsToIgnore)) continue;
            fileList.add(f.getAbsolutePath());
        }
        return fileList;
    }

    private boolean ignoreFile(String name, List<String> extensionsToIgnore) {
        String extension = "";
        int i = name.lastIndexOf(46);
        if (i > 0) {
            extension = name.substring(i + 1);
            return extensionsToIgnore.contains(extension);
        }
        return false;
    }

    @Override
    public Results saveFile(byte[] bytes, String destinationFilePath, boolean deleteExisting) {
        return this.saveFile(bytes, destinationFilePath, deleteExisting, false);
    }

    @Override
    public Results saveFile(byte[] bytes, String destinationFilePath, boolean deleteExistingDestinationFile, boolean overwriteReadOnlyDestinationFile) {
        if (destinationFilePath.endsWith(FRONTSLASH)) {
            Results results = new Results();
            String slashRemoved = destinationFilePath.substring(0, destinationFilePath.length() - 1);
            File newDir = new File(slashRemoved);
            boolean created = this.createDirectory(newDir);
            if (!created) {
                results.setStatus(4);
                String message = MessageFormat.format("Unable to create destination directory {0}.", slashRemoved);
                results.setMessage(message);
            }
            return results;
        }
        return FileUtilities.saveFile(bytes, destinationFilePath, deleteExistingDestinationFile, overwriteReadOnlyDestinationFile);
    }

    public void setAgentDataComponent(IAgentDataComponent agentDataComponent) {
        this._agentDataComponent = agentDataComponent;
    }

    void setAgentInfo(AgentInfo agentInfo) {
        this._agentInfo = agentInfo;
    }

    public void setAgentState(String agentStatus) {
        this._agentStatus = agentStatus;
    }

    public void setDeployAPI(IDeployAPI deployAPI) {
        this._deployAPI = deployAPI;
    }

    public void start() {
        String installLocation = System.getProperty(USER_DIR);
        String version = this.getAgentDataComponent().getAgentVersion();
        LOGGER.debug("Agent.start() creating new AgentInfo(" + version + ", " + installLocation + ")");
        this._agentInfo = new AgentInfo(version, installLocation);
        this.logAgentInfo();
    }

    private boolean startsWithWindowsDriveLetter(String value) {
        return value.matches("[a-zA-Z]:.*");
    }

    private boolean startsWithWindowsUnc(String value) {
        return value.matches("\\\\\\\\.*");
    }

    @Override
    public boolean stopAgent() {
        LOGGER.info("stopAgent(): Shutdown requested");
        AgentShutdown as = new AgentShutdown();
        as.start();
        return true;
    }

    private String toLowercase(String value) {
        Locale locale = Locale.getDefault();
        return value.toLowerCase(locale);
    }

    private String toString(String[] args) {
        char delimiter = ' ';
        return this.toString(args, delimiter);
    }

    private String toString(String[] args, char delimiter) {
        int size = args.length * 10;
        StringBuffer buffer = new StringBuffer(size);
        for (int i = 0; i < args.length; ++i) {
            String each = args[i];
            buffer.append(each);
            if (i >= args.length - 1) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public void unsetAgentDataComponent(IAgentDataComponent agentData) {
        this._agentDataComponent = null;
    }

    public void unsetDeployAPI(IDeployAPI deployAPI) {
        this._deployAPI = null;
    }

    public String validate() {
        return Agent.getProperty(OS_ARCH_PROPERTY_KEY);
    }

    @Override
    public String getSASHome() {
        String value = System.getProperty("java.home", ".");
        File directory = new File(value);
        File parent = directory.getParentFile();
        if (parent != null) {
            parent = parent.getParentFile();
        }
        if (parent != null) {
            parent = parent.getParentFile();
        }
        return parent.getAbsolutePath();
    }

    @Override
    public Map<String, Set<ValidationType>> getInstallQualInfo() throws IOException {
        String sashome = this.getSASHome();
        HashMap<String, Set<ValidationType>> iqMap = new HashMap<String, Set<ValidationType>>();
        String iqInfo = sashome + "/InstallMisc/InstallLogs/ValidationFileList.xml";
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ValidationListType.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement installJax = jaxbUnmarshaller.unmarshal((Source)new StreamSource(iqInfo), ValidationListType.class);
            ValidationListType iqList = null;
            iqList = (ValidationListType)installJax.getValue();
            for (ValidationType line : iqList.getSasfile()) {
                String name = line.getName();
                if (!name.contains("SASVersionedJarRepository\\eclipse\\plugins") && !name.contains("SASVersionedJarRepository/eclipse/plugins")) continue;
                String[] splitLine = this.isWindows() ? name.split("\\\\") : name.split(FRONTSLASH);
                String pluginName = splitLine[4];
                HashSet<ValidationType> set = (HashSet<ValidationType>)iqMap.get(pluginName);
                if (set == null) {
                    set = new HashSet<ValidationType>();
                }
                set.add(line);
                iqMap.put(pluginName, set);
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return iqMap;
    }

    private static class AgentShutdown
    extends Thread {
        private AgentShutdown() {
        }

        @Override
        public void run() {
            try {
                AgentShutdown.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                LOGGER.info("stopAgent(): Shutting down");
                System.exit(0);
            }
        }
    }

    private static final class Worker
    extends Thread {
        private final Process process;
        private Integer exit;

        private Worker(Process process) {
            this.process = process;
        }

        public String getErrorMessage() {
            InputStream stream = this.process.getErrorStream();
            if (stream == null) {
                return "No output available from process";
            }
            return this.getErrorString(stream);
        }

        private String getErrorString(InputStream stream) {
            try {
                return new Scanner(stream).useDelimiter("\\A").next();
            }
            catch (Exception e) {
                return "Unable to get error stream from process";
            }
        }

        private Integer getExit() {
            return this.exit;
        }

        @Override
        public void run() {
            try {
                this.exit = this.process.waitFor();
            }
            catch (InterruptedException ignore) {
                return;
            }
        }
    }
}

