/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.TimeEventInterface;
import com.sas.scheduler.visuals.swing.TimeEventPanel;
import java.awt.Frame;
import java.util.Locale;
import javax.swing.JOptionPane;

public class TimeEventDialog
extends StandardDialog
implements TimeEventInterface {
    private static final long serialVersionUID = 1L;
    private TimeEventPanel m_timeEventPanel;
    private TimeEventInfo m_event;
    private boolean m_showTimezones;
    private boolean m_limitSkips;

    public TimeEventDialog(Frame owner, String dialogTitle) {
        this(owner, dialogTitle, null);
    }

    public TimeEventDialog(Frame owner, String dialogTitle, TimeEventInfo event) {
        this(owner, dialogTitle, event, false);
    }

    public TimeEventDialog(Frame owner, String dialogTitle, TimeEventInfo event, boolean showTimeZone) {
        this(owner, dialogTitle, event, showTimeZone, false);
    }

    public TimeEventDialog(Frame owner, String dialogTitle, TimeEventInfo event, boolean showTimeZone, boolean limitSkips) {
        super(owner, dialogTitle, true);
        this.m_event = event;
        this.m_showTimezones = showTimeZone;
        this.m_limitSkips = limitSkips;
        this.init();
    }

    @Override
    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public void setScheduler(SchedulerServerInfo scheduler) {
    }

    @Override
    public void dispose() {
        if (this.m_timeEventPanel != null) {
            this.m_timeEventPanel.saveSettingsAndCleanUp();
            this.m_event = this.m_timeEventPanel.getEvent();
        }
        this.m_timeEventPanel = null;
        super.dispose();
    }

    @Override
    public TimeEventInterface getInstance(TimeEventInfo event) {
        return new TimeEventDialog(this.m_frame, this.getTitle(), event, this.m_showTimezones, this.m_limitSkips);
    }

    @Override
    public void setTimeEvent(TimeEventInfo event) {
        this.m_event = event;
        if (this.m_timeEventPanel != null) {
            this.m_timeEventPanel.setEvent(event);
        }
    }

    public void setRecurrenceEnabled(boolean enabled) {
        this.m_timeEventPanel.setRecurrenceEnabled(enabled);
    }

    @Override
    public TimeEventInfo getTimeEvent() {
        return this.m_event;
    }

    private void init() {
        this.m_timeEventPanel = new TimeEventPanel(this.m_frame, this.m_event, true, this.m_showTimezones, this.m_limitSkips);
        this.setMainPanel(this.m_timeEventPanel);
    }

    @Override
    protected boolean validateData() {
        if (this.m_timeEventPanel != null) {
            if (this.m_timeEventPanel.validateData()) {
                this.m_event = this.m_timeEventPanel.getEvent();
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    protected boolean onOK() throws SchedulerException {
        if (this.validateData()) {
            if (super.onOK()) {
                this.m_event.setName(this.m_event.toStringShortDesc(Locale.getDefault()));
                return true;
            }
        } else {
            JOptionPane.showMessageDialog(this, this.m_timeEventPanel.getErrorMessage(), this.getTitle(), 0);
        }
        return false;
    }
}

