/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SubflowPropertiesPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private JobInfo m_info = null;
    private JTextField m_name = new JTextField();
    private JTextField m_description = new JTextField();
    private boolean m_editable = true;

    public SubflowPropertiesPanel(JobInfo info) {
        this.m_info = info;
        this.initialize();
    }

    @Override
    public String getName() {
        return this.m_info.getName();
    }

    @Override
    public void setName(String text) {
        this.m_info.setName(text);
        this.m_name.setText(text);
    }

    public String getDescription() {
        return this.m_info.getDescription();
    }

    public boolean setDescription(String text) {
        this.m_info.setDescription(text);
        this.m_description.setText(text);
        return true;
    }

    public boolean isNameEditable() {
        return this.m_editable;
    }

    public void setNameEditable(boolean flag) {
        this.m_editable = flag;
        this.m_name.setEditable(this.m_editable);
    }

    private void initialize() {
        String nameText = m_bundle.getString("SubflowPropertiesPanel.NameLabel.txt");
        JLabel namelabel = new JLabel(Util.getLabelWithoutMnemonic((String)nameText));
        namelabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)nameText));
        namelabel.setLabelFor(this.m_name);
        String descText = m_bundle.getString("SubflowPropertiesPanel.DescLabel.txt");
        JLabel desclabel = new JLabel(Util.getLabelWithoutMnemonic((String)descText));
        desclabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)descText));
        desclabel.setLabelFor(this.m_description);
        GridBagConstraints gbc1 = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gbc2 = new GridBagConstraints(1, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.setLayout(new GridBagLayout());
        this.m_name.setPreferredSize(new Dimension(300, 20));
        this.m_name.setText(this.m_info.getName());
        this.m_description.setPreferredSize(new Dimension(300, 20));
        this.m_description.setText(this.m_info.getDescription());
        this.add((Component)namelabel, gbc1);
        this.add((Component)this.m_name, gbc2);
        ++gbc1.gridy;
        ++gbc2.gridy;
        this.add((Component)desclabel, gbc1);
        this.add((Component)this.m_description, gbc2);
    }

    @Override
    public boolean validateData() {
        if (this.m_editable) {
            this.m_info.setName(this.m_name.getText());
        }
        return this.m_info.setDescription(this.m_description.getText());
    }

    static {
        String strClassName = SubflowPropertiesPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

