/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.visuals.swing.ButtonsLayout;
import com.sas.scheduler.visuals.swing.CustomLayoutFocusTraversalPolicy;
import com.sas.scheduler.visuals.swing.HelpClassLoader;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class StandardPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String DATA_CHANGED_PROPERTY = "DataChanged";
    private boolean m_bListeningForChanges = true;
    private boolean m_bDataChanged = false;
    private cItemListener m_ItemListener = new cItemListener();
    private cListListener m_ListListener = new cListListener();
    private cDocListener m_DocListener = new cDocListener();
    private cPanelListener m_PanelListener = new cPanelListener();

    public StandardPanel() {
    }

    public StandardPanel(ButtonsLayout layout) {
        super(layout);
    }

    public void saveSettingsAndCleanUp() {
        this.m_ItemListener = null;
        this.m_ListListener = null;
        this.m_DocListener = null;
        this.m_PanelListener = null;
    }

    public boolean moveDataToView() {
        return true;
    }

    public boolean moveViewToData() {
        return true;
    }

    public void setListeningForChanges(boolean bListeningForChanges) {
        this.m_bListeningForChanges = bListeningForChanges;
    }

    public boolean isListeningForChanges() {
        return this.m_bListeningForChanges;
    }

    public void setDataChanged(boolean bDataChanged) {
        if (this.m_bDataChanged != bDataChanged) {
            boolean bOld = this.m_bDataChanged;
            this.m_bDataChanged = bDataChanged;
            this.firePropertyChange(DATA_CHANGED_PROPERTY, bOld, bDataChanged);
        }
    }

    public boolean hasDataChanged() {
        return this.m_bDataChanged;
    }

    protected void listenForDataChangesTo(JCheckBox cbx) {
        cbx.addItemListener(this.m_ItemListener);
    }

    protected void listenForDataChangesTo(JRadioButton rbn) {
        rbn.addItemListener(this.m_ItemListener);
    }

    protected void listenForDataChangesTo(JList lst) {
        lst.addListSelectionListener(this.m_ListListener);
    }

    protected void listenForDataChangesTo(JComboBox cmb) {
        cmb.addItemListener(this.m_ItemListener);
    }

    protected void listenForDataChangesTo(JTextComponent txt) {
        txt.getDocument().addDocumentListener(this.m_DocListener);
    }

    protected void listenForDataChangesTo(JPanel pnl) {
        pnl.addPropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_PanelListener);
    }

    protected void stopListeningForDataChangesTo(JCheckBox cbx) {
        cbx.removeItemListener(this.m_ItemListener);
    }

    protected void stopListeningForDataChangesTo(JRadioButton rbn) {
        rbn.removeItemListener(this.m_ItemListener);
    }

    protected void stopListeningForDataChangesTo(JList lst) {
        lst.removeListSelectionListener(this.m_ListListener);
    }

    protected void stopListeningForDataChangesTo(JComboBox cmb) {
        cmb.removeItemListener(this.m_ItemListener);
    }

    protected void stopListeningForDataChangesTo(JTextComponent txt) {
        txt.getDocument().removeDocumentListener(this.m_DocListener);
    }

    protected void stopListeningForDataChangesTo(JPanel pnl) {
        pnl.removePropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_PanelListener);
    }

    public boolean validateData() {
        return true;
    }

    public ClassLoader getHelpClassLoader() {
        return HelpClassLoader.getInstance(this.getClass());
    }

    public Component getDefaultFocusComponent() {
        return null;
    }

    @Override
    public void requestFocus() {
        Component cmp = CustomLayoutFocusTraversalPolicy.getDefaultFocusComponent(this);
        if (cmp != null) {
            cmp.requestFocus();
        }
    }

    public boolean canClose() {
        return true;
    }

    public boolean onParentOK() {
        return true;
    }

    public boolean onParentApply() {
        return true;
    }

    public boolean onParentCancel() {
        return true;
    }

    private class cPanelListener
    implements PropertyChangeListener {
        private cPanelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (StandardPanel.this.isListeningForChanges() && ((Boolean)e.getNewValue()).booleanValue()) {
                StandardPanel.this.setDataChanged(true);
            }
        }
    }

    private class cDocListener
    implements DocumentListener {
        private cDocListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (StandardPanel.this.isListeningForChanges()) {
                StandardPanel.this.setDataChanged(true);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (StandardPanel.this.isListeningForChanges()) {
                StandardPanel.this.setDataChanged(true);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (StandardPanel.this.isListeningForChanges()) {
                StandardPanel.this.setDataChanged(true);
            }
        }
    }

    private class cListListener
    implements ListSelectionListener {
        private cListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (StandardPanel.this.isListeningForChanges()) {
                StandardPanel.this.setDataChanged(true);
            }
        }
    }

    private class cItemListener
    implements ItemListener {
        private cItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (StandardPanel.this.isListeningForChanges()) {
                StandardPanel.this.setDataChanged(true);
            }
        }
    }
}

