/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.visuals.swing.ButtonsLayout;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class RescheduleOptionsPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private JDialog m_dialog;
    private static int m_action;
    public static final int RunNow = 0;
    public static final int Reschedule = 1;
    public static final int Cancel = 2;

    public RescheduleOptionsPanel(JDialog dia, String name, boolean modified) {
        this.m_dialog = dia;
        this.__initialize(name, modified);
    }

    public int getSelectedButton() {
        return m_action;
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_dialog = null;
    }

    private void __initialize(String flowName, boolean modified) {
        String runNow = m_bundle.getString("RescheduleOptionsPanel.Button.RunNow.txt");
        JButton runNowBtn = new JButton(runNow);
        String resch = m_bundle.getString("RescheduleOptionsPanel.Button.Reschedule.txt");
        JButton reschBtn = new JButton(resch);
        String cancel = m_bundle.getString("RescheduleOptionsPanel.Button.Cancel.txt");
        JButton cancelBtn = new JButton(cancel);
        runNowBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                m_action = 0;
                RescheduleOptionsPanel.this.m_dialog.dispose();
                JRootPane container = RescheduleOptionsPanel.this.getRootPane();
                SwingUtilities.replaceUIInputMap(container, 2, null);
            }
        });
        reschBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                m_action = 1;
                RescheduleOptionsPanel.this.m_dialog.dispose();
                JRootPane container = RescheduleOptionsPanel.this.getRootPane();
                SwingUtilities.replaceUIInputMap(container, 2, null);
            }
        });
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                m_action = 2;
                RescheduleOptionsPanel.this.m_dialog.dispose();
                JRootPane container = RescheduleOptionsPanel.this.getRootPane();
                SwingUtilities.replaceUIInputMap(container, 2, null);
            }
        });
        String message = modified ? MessageFormat.format(m_bundle.getString("RescheduleOptionsPanel.MetadataChange.Message.fmt"), flowName, runNow, resch, cancel) : MessageFormat.format(m_bundle.getString("RescheduleOptionsPanel.Resubmission.Message.fmt"), flowName, runNow, resch, cancel);
        JTextArea txtMessage = new JTextArea();
        Font fnt = this.getFont();
        txtMessage.setFont(new Font("Dialog", fnt.getStyle(), fnt.getSize()));
        txtMessage.setColumns(30);
        txtMessage.setText(message);
        txtMessage.setBackground(SystemColor.control);
        txtMessage.setWrapStyleWord(true);
        txtMessage.setLineWrap(true);
        txtMessage.setEditable(false);
        StandardPanel pnlButtons = new StandardPanel();
        pnlButtons.setLayout(new ButtonsLayout(0, 0));
        pnlButtons.add(runNowBtn);
        pnlButtons.add(reschBtn);
        pnlButtons.add(cancelBtn);
        GridBagConstraints gbc_label = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        GridBagConstraints gbc_buttons = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 15, 3, new Insets(5, 5, 5, 0), 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)txtMessage, gbc_label);
        this.add((Component)pnlButtons, gbc_buttons);
    }

    static {
        String strClassName = RescheduleOptionsPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        m_action = -1;
    }
}

