/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.visuals.swing.AbstractProgressDialog;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ProgressIndicator {
    private static final ResourceBundle m_bundle;
    private Frame m_frmParent;
    private String m_sMessage;
    private String m_sTitle;
    private String m_errorMsg = null;
    private Timer m_timerDelay;
    private Timer m_timerUpdate;
    private int m_msDelay = 0;
    private int m_msUpdate = 250;
    private Thread m_threadOperation;
    private AbstractProgressDialog m_dlgProgress;
    private Dimension m_dimMessage;

    public ProgressIndicator() {
    }

    public ProgressIndicator(String sMessage) {
        this.m_sMessage = sMessage;
    }

    public ProgressIndicator(Frame frmParent, String sMessage, String sTitle) {
        this.m_sMessage = sMessage;
        this.m_sTitle = sTitle;
        this.m_frmParent = frmParent;
    }

    public int getDelayBeforeProgressCancelDialog() {
        return this.m_msDelay;
    }

    public void setDelayBeforeProgressCancelDialog(int msDelay) {
        this.m_msDelay = msDelay < 0 ? 1500 : msDelay;
    }

    public int getUpdateDelay() {
        return this.m_msUpdate;
    }

    public void setUpdateDelay(int msUpdate) {
        this.m_msUpdate = msUpdate < 0 ? 250 : msUpdate;
    }

    protected boolean isOperationStillRunning() {
        return this.m_threadOperation != null && this.m_threadOperation.isAlive();
    }

    public String getMessage() {
        if (this.m_sMessage == null) {
            this.m_sMessage = m_bundle.getString("ProgressIndicator.RetrievingData");
        }
        return this.m_sMessage;
    }

    public void setMessage(final String sMessage) {
        this.m_sMessage = sMessage;
        if (this.m_dlgProgress != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractProgressDialog dlg = ProgressIndicator.this.m_dlgProgress;
                    if (dlg != null) {
                        dlg.setText(sMessage);
                    }
                }
            });
        }
    }

    public void setMessagePreferredSize(Dimension dimMessageLabel) {
        this.m_dimMessage = dimMessageLabel;
    }

    public Dimension getMessagePreferredSize() {
        return this.m_dimMessage;
    }

    public String getTitle() {
        if (this.m_sTitle == null) {
            this.m_sTitle = m_bundle.getString("ProgressIndicator.Title.Accessing.txt");
        }
        return this.m_sTitle;
    }

    public void setTitle(String sTitle) {
        this.m_sTitle = sTitle;
    }

    public boolean hasErrors() {
        return this.m_errorMsg != null;
    }

    public String getErrors() {
        return this.m_errorMsg;
    }

    public Thread getBackgroundThread() {
        return this.m_threadOperation;
    }

    public void execute(Runnable runOperation) {
        this.execute(runOperation, null);
    }

    public void execute(Runnable runOperation, Runnable runCompletionNotification) {
        this.m_frmParent.setCursor(Cursor.getPredefinedCursor(3));
        this.m_errorMsg = null;
        try {
            this.m_threadOperation = this.createOperationThread(runOperation, runCompletionNotification);
            if (this.m_msDelay <= 0) {
                this.m_dlgProgress = this.createProgressDialog();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ProgressIndicator.this.m_threadOperation != null) {
                            ProgressIndicator.this.m_threadOperation.start();
                        }
                    }
                });
                this.m_dlgProgress.setVisible(true);
                this.m_dlgProgress = null;
            } else {
                this.m_threadOperation.start();
                this.startDelayTimerSync();
            }
        }
        finally {
            this.m_frmParent.setCursor(null);
        }
    }

    protected void startDelayTimerSync() {
        for (long howLongHaveWeBeenWaiting = 0L; howLongHaveWeBeenWaiting < (long)this.m_msDelay; howLongHaveWeBeenWaiting += 250L) {
            try {
                Thread.sleep(250L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.isOperationStillRunning()) continue;
            return;
        }
        this.m_dlgProgress = this.createProgressDialog();
        this.m_dlgProgress.setCursor(Cursor.getPredefinedCursor(3));
        this.m_dlgProgress.setVisible(true);
        this.m_dlgProgress.setCursor(Cursor.getPredefinedCursor(0));
        this.m_dlgProgress = null;
    }

    protected void startDelayTimer() {
        this.m_timerDelay = new Timer(this.m_msDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressIndicator.this.m_timerDelay.stop();
                if (ProgressIndicator.this.isOperationStillRunning()) {
                    ProgressIndicator.this.m_dlgProgress = ProgressIndicator.this.createProgressDialog();
                    ProgressIndicator.this.m_dlgProgress.setCursor(Cursor.getPredefinedCursor(3));
                    ProgressIndicator.this.m_dlgProgress.setVisible(true);
                    ProgressIndicator.this.m_dlgProgress.setCursor(Cursor.getPredefinedCursor(0));
                    ProgressIndicator.this.m_dlgProgress = null;
                }
            }
        });
        this.m_timerDelay.start();
    }

    protected void startUpdateTimer() {
        this.m_timerUpdate = new Timer(this.m_msUpdate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ProgressIndicator.this.isOperationStillRunning()) {
                    ProgressIndicator.this.m_timerUpdate.stop();
                }
            }
        });
        this.m_timerUpdate.start();
    }

    protected AbstractProgressDialog createProgressDialog() {
        cProgressDialog dlgProgress = new cProgressDialog(this.m_frmParent, this.m_sTitle, this.m_sMessage);
        if (this.m_dimMessage != null) {
            dlgProgress.setTextPreferredSize(this.m_dimMessage);
        }
        return dlgProgress;
    }

    protected Thread createOperationThread(Runnable runOperation, Runnable runCompletionNotification) {
        return new cOperationThread(runOperation, runCompletionNotification);
    }

    static {
        String strClassName = ProgressIndicator.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    protected class cProgressDialog
    extends AbstractProgressDialog {
        private static final long serialVersionUID = 1L;

        public cProgressDialog(Frame frmParent, String sTitle, String sText) {
            super(frmParent, sTitle, sText);
        }

        @Override
        protected boolean isComplete() {
            return !ProgressIndicator.this.isOperationStillRunning();
        }
    }

    protected class cRunnableMethod
    implements Runnable {
        protected Object m_oTarget;
        protected Object[] m_oaArgs;
        protected Method m_method;
        protected Object m_oReturnValue;

        protected cRunnableMethod() {
        }

        public void init(Object oTarget, String sMethod, Object[] oaArgs) {
            if (oTarget == null || sMethod == null) {
                return;
            }
            this.m_oTarget = oTarget;
            this.m_oaArgs = oaArgs;
            try {
                if (oaArgs == null) {
                    this.m_method = this.m_oTarget.getClass().getMethod(sMethod, null);
                } else {
                    Class[] caArgs = new Class[oaArgs.length];
                    int nArgs = oaArgs.length;
                    for (int iArg = 0; iArg < nArgs; ++iArg) {
                        caArgs[iArg] = oaArgs[iArg].getClass();
                    }
                    this.m_method = this.m_oTarget.getClass().getMethod(sMethod, caArgs);
                }
            }
            catch (NoSuchMethodException e) {
                String sMessage = MessageFormat.format(m_bundle.getString("ProgressIndicator.NoMethod.Exception.fmt"), sMethod, this.m_oTarget.getClass());
                ProgressIndicator.this.m_errorMsg = ProgressIndicator.this.m_errorMsg != null ? ProgressIndicator.this.m_errorMsg + "\n" + sMessage : sMessage;
            }
        }

        @Override
        public void run() {
            try {
                this.m_oReturnValue = this.m_method.invoke(this.m_oTarget, this.m_oaArgs);
            }
            catch (InvocationTargetException e) {
                String sMessage = MessageFormat.format(m_bundle.getString("ProgressIndicator.Callback.Exception.fmt"), this.m_method.getName(), this.m_oTarget);
                ProgressIndicator.this.m_errorMsg = ProgressIndicator.this.m_errorMsg != null ? ProgressIndicator.this.m_errorMsg + "\n" + sMessage : sMessage;
            }
            catch (IllegalAccessException e) {
                String message = e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "IllegalAccessException";
                ProgressIndicator.this.m_errorMsg = ProgressIndicator.this.m_errorMsg != null ? ProgressIndicator.this.m_errorMsg + "\n" + message : message;
            }
            catch (RuntimeException e) {
                String message = e.getLocalizedMessage() != null ? e.toString() : "RuntimeException";
                System.err.println(message);
                e.printStackTrace();
            }
            catch (Throwable t) {
                String message = t.getLocalizedMessage() != null ? t.toString() : "RuntimeException";
                System.err.println(message);
                t.printStackTrace();
            }
        }

        public Object getReturnValue() {
            return this.m_oReturnValue;
        }
    }

    protected class cOperationThread
    extends Thread {
        protected Runnable m_runOperation;
        protected Runnable m_runCompletionNotification;

        public cOperationThread(Runnable runOperation, Runnable runCompletionNotification) {
            super(ProgressIndicator.this.m_sTitle != null ? ProgressIndicator.this.m_sTitle : "BackgroundOperation");
            this.m_runOperation = runOperation;
            this.m_runCompletionNotification = runCompletionNotification;
            this.setPriority(5);
        }

        @Override
        public void run() {
            try {
                this.m_runOperation.run();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                ProgressIndicator.this.m_errorMsg = ProgressIndicator.this.m_errorMsg != null ? ProgressIndicator.this.m_errorMsg + "\n" + ex.toString() : ex.toString();
            }
            catch (Throwable t) {
                t.printStackTrace();
                ProgressIndicator.this.m_errorMsg = ProgressIndicator.this.m_errorMsg != null ? ProgressIndicator.this.m_errorMsg + "\n" + t.toString() : t.toString();
            }
            if (this.m_runCompletionNotification != null) {
                try {
                    SwingUtilities.invokeLater(this.m_runCompletionNotification);
                }
                catch (RuntimeException rte) {
                    ProgressIndicator.this.m_errorMsg = ProgressIndicator.this.m_errorMsg != null ? ProgressIndicator.this.m_errorMsg + "\n" + rte.toString() : rte.toString();
                }
            }
        }
    }
}

