/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import javax.swing.SwingUtilities;

public class OperationThread
extends Thread {
    private OperationThread m_this;
    private static final int MAXTHREADS = 1;
    private static volatile int m_running = 0;
    private static Object critsect = new Object();
    protected String m_name;
    protected Runnable m_runOperation;
    protected Runnable m_runCompletionNotification;

    public OperationThread(String name, Runnable runOperation, Runnable runCompletionNotification) {
        super(name);
        this.m_name = name;
        this.m_runOperation = runOperation;
        this.m_runCompletionNotification = runCompletionNotification;
        this.setPriority(1);
        this.m_this = this;
    }

    public void startThread() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OperationThread.this.m_this.start();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        while (m_running > 1) {
            try {
                this.wait(50000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Object e = critsect;
        synchronized (e) {
            ++m_running;
        }
        try {
            this.m_runOperation.run();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        if (this.m_runCompletionNotification != null) {
            try {
                SwingUtilities.invokeLater(this.m_runCompletionNotification);
            }
            catch (RuntimeException rte) {
                rte.printStackTrace();
            }
        }
        Object object = critsect;
        synchronized (object) {
            --m_running;
        }
        this.notify();
    }
}

