/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class LoginPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private JLabel m_usernameLabel = new JLabel(m_bundle.getString("LoginPanel.LogonView.UserName.txt"));
    private JTextField m_usernameText = new JTextField(15);
    private JLabel m_passwordLabel = new JLabel(m_bundle.getString("LoginPanel.LogonView.Password.txt"));
    private JPasswordField m_passwordText = new JPasswordField();
    private JCheckBox m_checkbox = null;
    private String m_user;
    private SealedString m_pass;

    public LoginPanel() {
        this.__layoutWidgets();
    }

    public LoginPanel(String checkbox) {
        this.m_checkbox = new JCheckBox(checkbox);
        this.__layoutWidgets();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        if (this.m_usernameText != null) {
            this.m_user = this.m_usernameText.getText();
        }
        if (this.m_passwordText != null) {
            this.m_pass = new SealedString(this.m_passwordText.getPassword());
        }
        this.m_usernameLabel = null;
        this.m_usernameText = null;
        this.m_passwordLabel = null;
        this.m_passwordText = null;
    }

    public String getUserName() {
        if (this.m_usernameText != null) {
            this.m_user = this.m_usernameText.getText();
        }
        return this.m_user;
    }

    @Deprecated
    public String getPassword() {
        if (this.m_passwordText != null) {
            this.m_pass = new SealedString(this.m_passwordText.getPassword());
        }
        return String.valueOf(this.m_pass != null ? this.m_pass.getCharacters() : null);
    }

    public SealedString getPasswordSealedString() {
        if (this.m_passwordText != null) {
            this.m_pass = new SealedString(this.m_passwordText.getPassword());
        }
        return this.m_pass;
    }

    public void setUserName(String userName) {
        this.m_usernameText.setText(userName);
    }

    @Deprecated
    public void setPassword(String password) {
        if (password == null) {
            this.m_passwordText = null;
        } else {
            this.m_passwordText.setText(password);
        }
    }

    public void setPasswordSealedString(SealedString password) {
        this.m_passwordText.setText(password != null ? String.valueOf(password.getCharacters()) : null);
    }

    public boolean checkboxSelected() {
        return this.m_checkbox != null ? this.m_checkbox.isSelected() : false;
    }

    private void __layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        if (this.m_checkbox == null) {
            this.setPreferredSize(new Dimension(315, 80));
        } else {
            int length = this.m_checkbox.getText().length();
            int width = length > 58 ? length * 6 : 350;
            Locale locale = Locale.getDefault();
            if (locale.getLanguage().equals(Locale.JAPANESE.getLanguage())) {
                width = length > 25 ? length * 14 : 350;
            }
            this.setPreferredSize(new Dimension(width, 100));
        }
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_usernameLabel, gbc);
        this.add(this.m_usernameLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_usernameText, gbc);
        this.add(this.m_usernameText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(12, 12, 0, 0);
        gridBagLayout.setConstraints(this.m_passwordLabel, gbc);
        this.add(this.m_passwordLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 12, 0, 12);
        gridBagLayout.setConstraints(this.m_passwordText, gbc);
        this.add(this.m_passwordText);
        if (this.m_checkbox != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(12, 12, 0, 0);
            gridBagLayout.setConstraints(this.m_checkbox, gbc);
            this.add(this.m_checkbox);
        }
    }

    static {
        String strClassName = LoginPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

