/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.visuals.swing.EnvironmentVariablesPanel;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class JobPropertiesPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private JobInfo m_info = null;
    private JTextField m_name = new JTextField();
    private JTextField m_command = new JTextField();
    private EnvironmentVariablesPanel m_pnlEnvironmentVariables;
    private Frame m_frame = null;
    private boolean m_editable = true;
    private boolean m_envVarsAllowed = false;

    public JobPropertiesPanel(JobInfo info) {
        this(null, info, false);
    }

    public JobPropertiesPanel(JobInfo info, boolean envVarsAllowed) {
        this(null, info, envVarsAllowed);
    }

    public JobPropertiesPanel(Frame frame, JobInfo info, boolean envVarsAllowed) {
        this.m_frame = frame;
        this.m_info = info;
        this.m_envVarsAllowed = envVarsAllowed;
        this.initialize();
    }

    @Override
    public String getName() {
        return this.m_info.getName();
    }

    @Override
    public void setName(String text) {
        this.m_info.setName(text);
        this.m_name.setText(text);
    }

    public String getCommandLine() {
        return this.m_info.getCommandLine();
    }

    public boolean setCommandLine(String text) {
        this.m_info.setCommandLine(text);
        this.m_command.setText(text);
        return true;
    }

    public boolean isEditable() {
        return this.m_editable;
    }

    public void setEditable(boolean flag) {
        this.m_editable = flag;
        this.m_name.setEditable(this.m_editable);
        this.m_command.setEditable(this.m_editable);
    }

    private void initialize() {
        String nameText = m_bundle.getString("JobPropertiesPanel.NameLabel.txt");
        JLabel namelabel = new JLabel(Util.getLabelWithoutMnemonic((String)nameText));
        namelabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)nameText));
        namelabel.setLabelFor(this.m_name);
        String commandText = m_bundle.getString("JobPropertiesPanel.CommandLabel.txt");
        JLabel cmdlabel = new JLabel(Util.getLabelWithoutMnemonic((String)commandText));
        cmdlabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)commandText));
        cmdlabel.setLabelFor(this.m_command);
        GridBagConstraints gbc1 = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gbc2 = new GridBagConstraints(1, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.setLayout(new GridBagLayout());
        this.m_name.setPreferredSize(new Dimension(300, 20));
        this.m_name.setText(this.m_info.getName());
        this.m_command.setPreferredSize(new Dimension(300, 20));
        this.m_command.setText(this.m_info.getCommandLine());
        this.add((Component)namelabel, gbc1);
        this.add((Component)this.m_name, gbc2);
        ++gbc1.gridy;
        ++gbc2.gridy;
        this.add((Component)cmdlabel, gbc1);
        this.add((Component)this.m_command, gbc2);
        if (this.m_envVarsAllowed) {
            ++gbc1.gridy;
            String list = this.m_info.getSchedulerResources();
            this.m_pnlEnvironmentVariables = new EnvironmentVariablesPanel(this.m_frame, list);
        }
    }

    @Override
    public boolean validateData() {
        this.m_info.setName(this.m_name.getText());
        if (this.m_envVarsAllowed) {
            this.m_pnlEnvironmentVariables.validateData();
        }
        return this.m_info.setCommandLine(this.m_command.getText());
    }

    static {
        String strClassName = JobPropertiesPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

