/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class FlowEmailNotificationPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private Frame m_frame;
    private FlowInfo m_flow;
    private JCheckBox m_notify;
    private JLabel m_whenLabel;
    private JCheckBox m_flowStarts;
    private JCheckBox m_flowEnds;
    private JRadioButton m_everyTime;
    private JRadioButton m_onlyErrors;
    private JLabel m_userLabel;
    private JTextField m_user;

    public FlowEmailNotificationPanel(Frame frame, FlowInfo flow) {
        this.m_frame = frame;
        this.m_flow = flow;
        this.__initialize();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_notify = null;
        this.m_whenLabel = null;
        this.m_flowStarts = null;
        this.m_flowEnds = null;
        this.m_everyTime = null;
        this.m_onlyErrors = null;
        this.m_userLabel = null;
        this.m_user = null;
    }

    private void __initialize() {
        this.setLayout(new GridBagLayout());
        this.m_notify = new JCheckBox(m_bundle.getString("FlowEmailNotificationPanel.CheckBox.NotifyLabel.txt"));
        this.m_notify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowEmailNotificationPanel.this.setWidgets();
            }
        });
        this.m_flowStarts = new JCheckBox(m_bundle.getString("FlowEmailNotificationPanel.CheckBox.StartsLabel.txt"));
        this.m_flowEnds = new JCheckBox(m_bundle.getString("FlowEmailNotificationPanel.CheckBox.EndsLabel.txt"));
        this.m_everyTime = new JRadioButton(m_bundle.getString("FlowEmailNotificationPanel.RadioButton.AlwaysLabel.txt"));
        this.m_onlyErrors = new JRadioButton(m_bundle.getString("FlowEmailNotificationPanel.RadioButton.ErrorOnlyLabel.txt"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_everyTime);
        buttonGroup.add(this.m_onlyErrors);
        this.m_whenLabel = new JLabel(m_bundle.getString("FlowEmailNotificationPanel.Criteria.Label.txt"));
        this.m_whenLabel.setToolTipText(m_bundle.getString("FlowEmailNotificationPanel.Criteria.ToolTip.txt"));
        this.m_userLabel = new JLabel(m_bundle.getString("FlowEmailNotificationPanel.User.Label.txt"));
        this.m_user = new JTextField();
        this.m_user.setToolTipText(m_bundle.getString("FlowEmailNotificationPanel.User.ToolTip.txt"));
        this.m_userLabel.setLabelFor(this.m_user);
        GridBagConstraints notify_gbc = new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints whenlabel_gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 20, 0, 0), 0, 0);
        GridBagConstraints start_gbc = new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints end_gbc = new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints every_gbc = new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0);
        GridBagConstraints only_gbc = new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0);
        GridBagConstraints userlabel_gbc = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 20, 0, 0), 0, 0);
        GridBagConstraints user_gbc = new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0);
        this.setBorder(new EtchedBorder());
        this.add((Component)this.m_notify, notify_gbc);
        this.add((Component)this.m_whenLabel, whenlabel_gbc);
        this.add((Component)this.m_flowStarts, start_gbc);
        this.add((Component)this.m_flowEnds, end_gbc);
        this.add((Component)this.m_everyTime, every_gbc);
        this.add((Component)this.m_onlyErrors, only_gbc);
        this.add((Component)this.m_userLabel, userlabel_gbc);
        this.add((Component)this.m_user, user_gbc);
    }

    public FlowInfo getInfo() {
        return this.m_flow;
    }

    @Override
    public void setEnabled(boolean flag) {
        this.m_notify.setEnabled(flag);
        this.m_whenLabel.setEnabled(flag);
        this.m_flowStarts.setEnabled(flag);
        this.m_flowEnds.setEnabled(flag);
        this.m_everyTime.setEnabled(flag);
        this.m_onlyErrors.setEnabled(flag);
        this.m_userLabel.setEnabled(flag);
        this.m_user.setEnabled(flag);
    }

    @Override
    public boolean moveDataToView() {
        int level = this.m_flow.emailNotificationLevel();
        if (level != -1) {
            this.m_notify.setSelected(true);
            switch (level) {
                case 0: {
                    this.m_flowStarts.setSelected(true);
                    this.m_flowEnds.setSelected(false);
                    this.m_everyTime.setSelected(false);
                    this.m_onlyErrors.setSelected(true);
                    break;
                }
                case 1: {
                    this.m_flowStarts.setSelected(true);
                    this.m_flowEnds.setSelected(true);
                    this.m_everyTime.setSelected(true);
                    this.m_onlyErrors.setSelected(false);
                    break;
                }
                case 2: {
                    this.m_flowStarts.setSelected(true);
                    this.m_flowEnds.setSelected(true);
                    this.m_everyTime.setSelected(false);
                    this.m_onlyErrors.setSelected(true);
                    break;
                }
                case 4: {
                    this.m_flowStarts.setSelected(false);
                    this.m_flowEnds.setSelected(true);
                    this.m_everyTime.setSelected(true);
                    this.m_onlyErrors.setSelected(false);
                    break;
                }
                case 3: {
                    this.m_flowStarts.setSelected(false);
                    this.m_flowEnds.setSelected(true);
                    this.m_everyTime.setSelected(false);
                    this.m_onlyErrors.setSelected(true);
                }
            }
        } else {
            this.m_notify.setSelected(false);
            this.m_flowStarts.setSelected(false);
            this.m_flowEnds.setSelected(true);
            this.m_everyTime.setSelected(false);
            this.m_onlyErrors.setSelected(true);
        }
        String user = this.m_flow.emailAddress();
        if (user != null) {
            this.m_user.setText(user);
        }
        this.setWidgets();
        return true;
    }

    @Override
    public boolean moveViewToData() {
        if (this.m_notify.isSelected()) {
            if (this.m_flowStarts.isSelected()) {
                if (this.m_flowEnds.isSelected()) {
                    if (this.m_everyTime.isSelected()) {
                        this.m_flow.setEmailNotification(true, 1, this.m_user.getText());
                    } else {
                        this.m_flow.setEmailNotification(true, 2, this.m_user.getText());
                    }
                } else {
                    this.m_flow.setEmailNotification(true, 0, this.m_user.getText());
                }
            } else if (this.m_flowEnds.isSelected()) {
                if (this.m_everyTime.isSelected()) {
                    this.m_flow.setEmailNotification(true, 4, this.m_user.getText());
                } else {
                    this.m_flow.setEmailNotification(true, 3, this.m_user.getText());
                }
            }
        } else {
            this.m_flow.setEmailNotification(false, -1, this.m_user.getText());
        }
        return true;
    }

    @Override
    public boolean validateData() {
        String user;
        if (this.m_notify.isSelected() && ((user = this.m_user.getText()) == null || user.length() < 1)) {
            MessageUtil.displayMessage(this.m_frame, m_bundle.getString("FlowEmailNotificationPanel.NoUserGiven.txt"), m_bundle.getString("FlowEmailNotificationPanel.Title.txt"), 0, -1);
            return false;
        }
        return true;
    }

    private void setWidgets() {
        if (this.m_notify.isSelected()) {
            this.m_whenLabel.setEnabled(true);
            this.m_flowStarts.setEnabled(true);
            this.m_flowEnds.setEnabled(true);
            this.m_everyTime.setEnabled(true);
            this.m_onlyErrors.setEnabled(true);
            this.m_userLabel.setEnabled(true);
            this.m_user.setEnabled(true);
        } else {
            this.m_whenLabel.setEnabled(false);
            this.m_flowStarts.setEnabled(false);
            this.m_flowEnds.setEnabled(false);
            this.m_everyTime.setEnabled(false);
            this.m_onlyErrors.setEnabled(false);
            this.m_userLabel.setEnabled(false);
            this.m_user.setEnabled(false);
        }
        this.invalidate();
    }

    static {
        String strClassName = FlowEmailNotificationPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

