/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.CalendarDialog;
import com.sas.swing.visuals.CalendarPanel;
import com.sas.text.NLInformats;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class DateRangePanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private Frame m_frame;
    private datePanel m_startDate;
    private nonePanel m_none;
    private datePanel m_endDate;
    private EtchedBorder m_focusBorder = new EtchedBorder();
    private boolean m_showEnd = true;
    private boolean m_enableEnd = true;
    private Icon m_calendar_icon = IconUtil.getIcon(IconUtil.NODE_Calendar);
    private JRadioButton m_indefinitely = new JRadioButton("", true);
    private JRadioButton m_endby = new JRadioButton("");

    public DateRangePanel(Frame frame) {
        this.m_frame = frame;
        this.__initialize();
    }

    public DateRangePanel(Frame frame, boolean show, boolean enable) {
        this.m_frame = frame;
        this.m_showEnd = show;
        this.m_enableEnd = enable;
        this.__initialize();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        if (this.m_startDate != null) {
            this.m_startDate.saveSettingsAndCleanUp();
        }
        if (this.m_endDate != null) {
            this.m_endDate.saveSettingsAndCleanUp();
        }
        if (this.m_none != null) {
            this.m_none.saveSettingsAndCleanUp();
        }
        this.m_frame = null;
        this.m_none = null;
        this.m_focusBorder = null;
        this.m_calendar_icon = null;
        this.m_indefinitely = null;
    }

    public Calendar getStartDate() {
        return this.m_startDate.getDate(0, 0);
    }

    public boolean setStartDate(Calendar date) {
        if (date != null) {
            return this.m_startDate.setDate(date);
        }
        return false;
    }

    public Calendar getEndDate() {
        if (this.m_endby.isSelected() && this.m_endDate != null) {
            return this.m_endDate.getDate(23, 59);
        }
        return null;
    }

    public boolean setEndDate(Calendar date) {
        if (date != null && this.m_endDate != null) {
            return this.m_endDate.setDate(date);
        }
        return false;
    }

    public boolean validateDate() {
        Calendar scal = this.m_startDate.getDate();
        Calendar ecal = this.m_endDate.getDate();
        return ecal == null || !scal.after(ecal);
    }

    private void __initialize() {
        TitledBorder border = null;
        border = this.m_showEnd ? new TitledBorder(m_bundle.getString("DateRangePanel.DateRangeLabel.txt")) : new TitledBorder(m_bundle.getString("DateRangePanel.DateLabel.txt"));
        this.setBorder(border);
        JLabel startDate = new JLabel(m_bundle.getString("DateRangePanel.startDateLabel.txt"));
        GridBagConstraints gbc_startLabel = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
        GridBagConstraints gbc_startPanel = new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.m_startDate = new datePanel(this.m_frame);
        this.setLayout(new GridBagLayout());
        this.add((Component)startDate, gbc_startLabel);
        this.add((Component)this.m_startDate, gbc_startPanel);
        if (this.m_showEnd) {
            GridBagConstraints gbc_endLabel = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_indefinitely = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0);
            GridBagConstraints gbc_nonePanel = new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
            GridBagConstraints gbc_endby = new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0);
            GridBagConstraints gbc_endPanel = new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
            JLabel endLabel = new JLabel(m_bundle.getString("DateRangePanel.endDateLabel.txt"));
            this.m_endDate = new datePanel(this.m_frame);
            this.m_none = new nonePanel(this.m_frame);
            GregorianCalendar currentDate = new GregorianCalendar(Locale.getDefault());
            int currentDay = currentDate.get(5);
            int currentMonth = currentDate.get(2);
            int endYear = currentDate.get(1) + 4;
            GregorianCalendar endDate = new GregorianCalendar(endYear, currentMonth, currentDay, 23, 59);
            this.m_endDate.setDate(endDate);
            this.m_endDate.setEnabled(this.m_enableEnd);
            FocusListener noneFocusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    Component cmp = DateRangePanel.this.m_none.getComponent(0);
                    if (cmp instanceof JLabel) {
                        ((JLabel)cmp).setBorder(DateRangePanel.this.m_focusBorder);
                    } else {
                        DateRangePanel.this.m_none.setBorder(DateRangePanel.this.m_focusBorder);
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    Component cmp = DateRangePanel.this.m_none.getComponent(0);
                    if (cmp instanceof JLabel) {
                        ((JLabel)cmp).setBorder(null);
                    } else {
                        DateRangePanel.this.m_none.setBorder(null);
                    }
                }
            };
            this.m_indefinitely.addFocusListener(noneFocusListener);
            FocusListener endFocusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    Component cmp = DateRangePanel.this.m_endDate.getComponent(0);
                    if (cmp instanceof JLabel) {
                        ((JLabel)cmp).setBorder(DateRangePanel.this.m_focusBorder);
                    } else {
                        DateRangePanel.this.m_endDate.setBorder(DateRangePanel.this.m_focusBorder);
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    Component cmp = DateRangePanel.this.m_endDate.getComponent(0);
                    if (cmp instanceof JLabel) {
                        ((JLabel)cmp).setBorder(null);
                    } else {
                        DateRangePanel.this.m_endDate.setBorder(null);
                    }
                }
            };
            this.m_endby.addFocusListener(endFocusListener);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.m_indefinitely);
            buttonGroup.add(this.m_endby);
            this.add((Component)endLabel, gbc_endLabel);
            this.add((Component)this.m_indefinitely, gbc_indefinitely);
            this.add((Component)this.m_none, gbc_nonePanel);
            this.add((Component)this.m_endby, gbc_endby);
            this.add((Component)this.m_endDate, gbc_endPanel);
            ActionListener endDateListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DateRangePanel.this.m_endby.setSelected(true);
                }
            };
            this.m_endDate.addEndDateListener(endDateListener);
        }
    }

    static {
        String strClassName = DateRangePanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    private class datePanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private JComboBox mc_recurDayComboBox = new JComboBox();
        private JComboBox mc_recurMonthComboBox = new JComboBox();
        private JComboBox mc_recurYearComboBox = new JComboBox();
        private Frame mc_frame;
        private JButton mc_calendarIcon = new JButton();
        private int mc_currentDay = 0;
        private int mc_currentMonth = 0;
        private int mc_currentYear = 0;
        private int mc_initialYear = 0;
        private Calendar mc_currentDate = new GregorianCalendar(Locale.getDefault());
        private ActionListener mc_al;

        public datePanel(Frame frame) {
            this.mc_frame = frame;
            this.__myinitialize();
        }

        @Override
        public void saveSettingsAndCleanUp() {
            super.saveSettingsAndCleanUp();
            this.mc_recurDayComboBox = null;
            this.mc_recurMonthComboBox = null;
            this.mc_recurYearComboBox = null;
            this.mc_frame = null;
            this.mc_currentDate = null;
            this.mc_calendarIcon = null;
            this.mc_al = null;
        }

        public Calendar getDate() {
            GregorianCalendar calendar = new GregorianCalendar(this.mc_currentYear, this.mc_currentMonth, this.mc_currentDay);
            return calendar;
        }

        public Calendar getDate(int hour, int minute) {
            GregorianCalendar calendar = new GregorianCalendar(this.mc_currentYear, this.mc_currentMonth, this.mc_currentDay, hour, minute);
            return calendar;
        }

        public boolean setDate(Calendar date) {
            this.mc_currentDate = date;
            this.mc_currentDay = date.get(5);
            this.mc_currentMonth = date.get(2);
            this.mc_currentYear = date.get(1);
            GregorianCalendar calendar = new GregorianCalendar(this.mc_currentYear, this.mc_currentMonth, this.mc_currentDay);
            this.updateCal(calendar);
            return true;
        }

        public void addEndDateListener(ActionListener al) {
            this.mc_al = al;
        }

        private void __myinitialize() {
            this.mc_currentDay = this.mc_currentDate.get(5);
            this.mc_currentMonth = this.mc_currentDate.get(2);
            this.mc_currentYear = this.mc_currentDate.get(1);
            for (int day = 1; day < 32; ++day) {
                String dayStr = m_bundle.getString("DateRangePanel.dayOfMonth." + String.valueOf(day) + ".txt");
                this.mc_recurDayComboBox.addItem(dayStr);
            }
            this.mc_recurDayComboBox.setSelectedIndex(this.mc_currentDay - 1);
            JLabel dayLabel = new JLabel(m_bundle.getString("DateRangePanel.DayLabel.txt"));
            dayLabel.setLabelFor(this.mc_recurDayComboBox);
            this.mc_recurMonthComboBox.setMaximumRowCount(12);
            this.mc_recurMonthComboBox.addItem(m_bundle.getString("DateRangePanel.recurMonthJanuary.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getString("DateRangePanel.recurMonthFebruary.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getString("DateRangePanel.recurMonthMarch.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getString("DateRangePanel.recurMonthApril.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getString("DateRangePanel.recurMonthMay.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getString("DateRangePanel.recurMonthJune.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getString("DateRangePanel.recurMonthJuly.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getString("DateRangePanel.recurMonthAugust.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getString("DateRangePanel.recurMonthSeptember.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getString("DateRangePanel.recurMonthOctober.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getString("DateRangePanel.recurMonthNovember.txt"));
            this.mc_recurMonthComboBox.addItem(m_bundle.getString("DateRangePanel.recurMonthDecember.txt"));
            this.mc_recurMonthComboBox.setSelectedIndex(this.mc_currentMonth);
            JLabel monthLabel = new JLabel(m_bundle.getString("DateRangePanel.MonthLabel.txt"));
            monthLabel.setLabelFor(this.mc_recurMonthComboBox);
            this.mc_recurYearComboBox.setMaximumRowCount(100);
            int maxYear = 2110;
            try {
                maxYear = new Integer(m_bundle.getString("DateRangePanel.maxyear.lcl"));
            }
            catch (Exception ex) {
                maxYear = this.mc_currentYear + 50;
            }
            this.mc_initialYear = this.mc_currentYear;
            for (int year = this.mc_currentYear; year <= maxYear; ++year) {
                String yearStr = m_bundle.getString("DateRangePanel.year." + String.valueOf(year) + ".txt");
                this.mc_recurYearComboBox.addItem(yearStr);
            }
            this.mc_recurYearComboBox.setSelectedIndex(this.mc_currentYear - this.mc_initialYear);
            this.mc_recurYearComboBox.setMaximumRowCount(10);
            JLabel yearLabel = new JLabel(m_bundle.getString("DateRangePanel.YearLabel.txt"));
            yearLabel.setLabelFor(this.mc_recurYearComboBox);
            this.mc_calendarIcon.setIcon(DateRangePanel.this.m_calendar_icon);
            GridBagConstraints gbc_oneLabel = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            GridBagConstraints gbc_one = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            GridBagConstraints gbc_twoLabel = new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            GridBagConstraints gbc_two = new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            GridBagConstraints gbc_threeLabel = new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            GridBagConstraints gbc_three = new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            GridBagConstraints gbc_cal = new GridBagConstraints(6, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            this.setLayout(new GridBagLayout());
            String order = NLInformats.getDateStyle((Locale)Locale.getDefault());
            int day = order.indexOf(68);
            int month = order.indexOf(77);
            int year = order.indexOf(89);
            if (day < 0 || month < 0 || year < 0 || day == month || day == year || month == year || day > 2 || month > 2 || year > 2) {
                day = 0;
                month = 1;
                year = 2;
            }
            switch (day) {
                default: {
                    this.add((Component)dayLabel, gbc_oneLabel);
                    this.add((Component)this.mc_recurDayComboBox, gbc_one);
                    break;
                }
                case 1: {
                    this.add((Component)dayLabel, gbc_twoLabel);
                    this.add((Component)this.mc_recurDayComboBox, gbc_two);
                    break;
                }
                case 2: {
                    this.add((Component)dayLabel, gbc_threeLabel);
                    this.add((Component)this.mc_recurDayComboBox, gbc_three);
                }
            }
            switch (month) {
                default: {
                    this.add((Component)monthLabel, gbc_oneLabel);
                    this.add((Component)this.mc_recurMonthComboBox, gbc_one);
                    break;
                }
                case 1: {
                    this.add((Component)monthLabel, gbc_twoLabel);
                    this.add((Component)this.mc_recurMonthComboBox, gbc_two);
                    break;
                }
                case 2: {
                    this.add((Component)monthLabel, gbc_threeLabel);
                    this.add((Component)this.mc_recurMonthComboBox, gbc_three);
                }
            }
            switch (year) {
                default: {
                    this.add((Component)yearLabel, gbc_oneLabel);
                    this.add((Component)this.mc_recurYearComboBox, gbc_one);
                    break;
                }
                case 1: {
                    this.add((Component)yearLabel, gbc_twoLabel);
                    this.add((Component)this.mc_recurYearComboBox, gbc_two);
                    break;
                }
                case 2: {
                    this.add((Component)yearLabel, gbc_threeLabel);
                    this.add((Component)this.mc_recurYearComboBox, gbc_three);
                }
            }
            this.add((Component)this.mc_calendarIcon, gbc_cal);
            DayComboBoxListener dcl = new DayComboBoxListener(this.mc_recurDayComboBox, this.mc_recurMonthComboBox, this.mc_recurYearComboBox);
            this.mc_recurDayComboBox.addActionListener(dcl);
            this.mc_recurMonthComboBox.addActionListener(dcl);
            this.mc_recurYearComboBox.addActionListener(dcl);
            this.mc_calendarIcon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalendarPanel calendarPanel = new CalendarPanel();
                    calendarPanel.setShowWeekdayHeaders(true);
                    calendarPanel.showOKButton(true);
                    Double dX = new Double(datePanel.this.getLocationOnScreen().getX());
                    Integer h = new Integer(datePanel.this.getHeight());
                    Double dY = new Double(datePanel.this.getLocationOnScreen().getY() + h.doubleValue());
                    String dialogTitle = m_bundle.getString("DataRangePanel.calendarLabel.txt");
                    CalendarDialog dialog = new CalendarDialog(DateRangePanel.this.m_frame, dialogTitle, calendarPanel);
                    dialog.setLocation(dX.intValue(), dY.intValue());
                    GregorianCalendar calendar = new GregorianCalendar(datePanel.this.mc_currentYear, datePanel.this.mc_currentMonth, datePanel.this.mc_currentDay);
                    calendarPanel.setSelectedDate(calendar);
                    dialog.setVisible(true);
                    if (calendarPanel.okClicked()) {
                        GregorianCalendar date = calendarPanel.getSelectedDate();
                        datePanel.this.updateCal(date);
                    }
                }
            });
        }

        private void updateCal(GregorianCalendar date) {
            try {
                if (date != null) {
                    this.mc_currentDate = date;
                    this.mc_currentDay = this.mc_currentDate.get(5);
                    this.mc_recurDayComboBox.setSelectedIndex(this.mc_currentDay - 1);
                    this.mc_currentMonth = this.mc_currentDate.get(2);
                    this.mc_recurMonthComboBox.setSelectedIndex(this.mc_currentMonth);
                    this.mc_currentYear = this.mc_currentDate.get(1);
                    if (this.mc_currentYear >= this.mc_initialYear) {
                        this.mc_recurYearComboBox.setSelectedIndex(this.mc_currentYear - this.mc_initialYear);
                    } else {
                        MessageUtil.displayMessage(this.mc_frame, m_bundle.getString("DateRangePanel.errorPastDate.txt"), m_bundle.getString("Common.TimeEvent.ErrorMsg.Title.txt"), 0, -1);
                    }
                    if (this.mc_al != null) {
                        ActionEvent e = new ActionEvent(this, 1001, null);
                        this.mc_al.actionPerformed(e);
                    }
                }
            }
            catch (RuntimeException ex) {
                String message = ex.getLocalizedMessage();
                if (message == null || message.length() == 0) {
                    message = ex.toString();
                }
                MessageUtil.displayMessage(this.mc_frame, message, m_bundle.getString("Common.TimeEvent.ErrorMsg.Title.txt"), 0, -1);
            }
        }

        private class DayComboBoxListener
        implements ActionListener {
            JComboBox mc_day = null;
            JComboBox mc_month = null;
            JComboBox mc_year = null;

            public DayComboBoxListener(JComboBox day, JComboBox month, JComboBox year) {
                this.mc_day = day;
                this.mc_month = month;
                this.mc_year = year;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                datePanel.this.mc_currentYear = this.mc_year.getSelectedIndex() + datePanel.this.mc_initialYear;
                datePanel.this.mc_currentMonth = this.mc_month.getSelectedIndex();
                datePanel.this.mc_currentDay = this.mc_day.getSelectedIndex() + 1;
                int month = this.mc_month.getSelectedIndex() + 1;
                int maxDay = 31;
                switch (month) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 12: {
                        maxDay = 31;
                        break;
                    }
                    case 2: {
                        int year = this.mc_year.getSelectedIndex() + datePanel.this.mc_initialYear;
                        GregorianCalendar currentDate = new GregorianCalendar(Locale.getDefault());
                        if (currentDate.isLeapYear(year)) {
                            maxDay = 29;
                            break;
                        }
                        maxDay = 28;
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 9: 
                    case 11: {
                        maxDay = 30;
                    }
                }
                this.mc_day.removeAllItems();
                for (int day = 1; day <= maxDay; ++day) {
                    String dayStr = m_bundle.getString("DateRangePanel.dayOfMonth." + String.valueOf(day) + ".txt");
                    this.mc_day.addItem(dayStr);
                }
                if (datePanel.this.mc_currentDay > 0) {
                    this.mc_day.setSelectedIndex(datePanel.this.mc_currentDay - 1);
                }
                if (datePanel.this.mc_al != null) {
                    datePanel.this.mc_al.actionPerformed(e);
                }
            }
        }
    }

    private class nonePanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;

        public nonePanel(Frame frame) {
            this.__myinitialize();
        }

        private void __myinitialize() {
            JLabel noneLabel = new JLabel(m_bundle.getString("DateRangePanel.recurrencePeriodIndefinitelyLabel.txt"));
            GridBagConstraints gbc_noneLabel = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            this.setLayout(new GridBagLayout());
            this.add((Component)noneLabel, gbc_noneLabel);
        }
    }
}

